<?php

use Drupal\migrate\MigrateSkipRowException;
use Drupal\cforge\EventSubscriber\MigrationSubscriber;
use Drupal\user\Entity\User;
use Drupal\Core\Database\Database;
use Drupal\Core\StringTranslation\TranslatableMarkup;

 /**
  * Implements hook_migration_plugins_alter().
  */
function _cforge_migration_plugins_alter(array &$definitions)  {
  //when this runs a subsequent time, previously exported items are counted twice.
  foreach (array_keys($definitions) as $key) {
    if (substr($key, 0, 8) == 'upgrade_') {
      unset($definitions[$key]);
    }
  }

  //enable any optional modules from D7
  if ($database_info = \Drupal::state()->get('migrate_drupal_7')) {
    Database::addConnectionInfo('migrate', 'default', $database_info['database']);
    $exclude = ['views_bulk_operations', 'taxonomy_manager'];
    $enabled_d7_modules = Database::getConnection('default', 'upgrade')->select('system', 's')
      ->condition('status', 1)
      ->condition('type', 'module')
      ->condition('name', $exclude, 'NOT IN')
      ->fields('s', ['name'])
      ->execute()->fetchCol();
    sort($enabled_d7_modules);
    $map = [
      'cforge_solsearch' => 'smallads_index',
      'cforge_hosted' => 'cforge_ladmin',
      'cforge_geo' => 'smallads_geo',
      'cfprod_smtp_headers' => 'cforge_hosted'
    ];
    $module_handler = \Drupal::moduleHandler();
    foreach ($enabled_d7_modules as $module) {
      $new_module = isset($map[$module]) ? $map[$module] : $module;
      if (!$module_handler->moduleExists($new_module)) {
        $install_d8_modules[] = $new_module;
      }
    }
    if ($install_d8_modules) {
      $discovery = new Drupal\Core\Extension\ExtensionDiscovery(\Drupal::root());
      if ($modules = array_intersect($install_d8_modules, array_keys($discovery->scan('module')))) {
        drupal_set_message('Installing optional modules '.implode(', ', $modules) . ' from D7 need to refreshh the migration plugins', 'warning');
        \Drupal::service('module_installer')->install($modules);
      }
    }
  }
  else{
    trigger_error('Cannot find source Db', E_USER_ERROR);
  }

  $definitions['d7_block']['process']['region']['map']['sky_seldulac']['sky_seldulac'] = [
    'help' => 'top',
    'headerright' => null,
    'navigation' => 'top',
    'contentbottom' => 'content',
    'contentfooter' => 'footer',
    'footer' => null
  ];
  $definitions['d7_filter_format']['process']['filters']['id']['map'] = MigrationSubscriber::FILTER_FORMATS;
  $definitions['d7_filter_format']['process']['filters']['id']['default_value'] = 'plain_text';

  //in 8.4-rc2 menu items are failing validation because their routes haven't been migrated yet
  $definitions['d7_menu_links']['migration_dependencies']['required'][] = 'd7_node';
  $definitions['d7_menu_links']['migration_dependencies']['required'][] = 'd7_contact';
  $definitions['d7_comment']['migration_dependencies']['required'][] = 'd7_user';

  // Simplify the comment  type process, which is confused by the renamings of things.
  // Then see
  $definitions['d7_comment']['process']['comment_type'] = 'comment_type';
  foreach ($definitions as &$def) {
    if (isset($def['process']['event_date'])) {
      $def['process']['date'] = $def['process']['event_date'];
      $def['process']['date']['process']['value']['to_format'] = 'Y-m-d\TH:i:s';
      unset($def['process']['event_date']);
    }
  }

  $definitions['d7_file']['source']['constants']['source_base_path'] = DRUPAL_ROOT;
  $definitions['d7_menu']['process']['id']['bypass'] = 'FALSE';//don't import any unknown menus

  unset(
    // I don't know why these are being included
    $definitions['user_profile_field'],
    $definitions['user_profile_field_instance'],
    $definitions['user_profile_entity_display'],
    $definitions['user_profile_entity_form_display'],
    // Do not inherit any view modes
    $definitions['d7_view_mode'],
    $definitions['d7_comment_entity_form_display'],
    $definitions['d7_comment_entity_display'],
    $definitions['d7_comment_field_instance'],
    $definitions['d7_filter_format']['process']['filters']['id']['bypass']
  );
}

/**
 * Implements hook_migrate_prepare_row().
 *
 * Do it here for all the features as well
 *
 * @return NULL|boolean
 *
 * @throw MigrateSkipRowException
 *
 * @see migrate.api.php
 */
function _cforge_migrate_prepare_row($row, $source, $migration) {
  if ($source->getPluginId()== 'd7_field' or $source->getPluginId()== 'd7_field_instance') {
    //These fields have no equivalent in d8
    if (in_array($source->getPluginId(), ['d7_field', 'd7_field_instance'])) {
      // These fields have no equivalent fields in d8
      $existing_fields = [
        'account_offline', // Now a user data field @todo
        'manage_responsibility',// Abandoned.
        'offers_wants_types'// Abandoned
      ];
      $field_name = $row->getSourceProperty('field_name');
      if (in_array($field_name, $existing_fields)) {
        return FALSE;
      }
    }
    return;
  }

  switch ($migration->id()) {
    case 'd7_filter_format':
      $ignore = array_keys(MigrationSubscriber::FILTER_FORMATS);
      if (in_array($row->getSourceProperty('format'), $ignore)) {
        return FALSE;
      }
      break;

    case 'd7_node_type':
      // don't migrate document
      if (in_array($row->getSourceProperty('type'), ['document', 'community_task', 'event'])) {
        return FALSE;
      }
      break;

    case 'd7_comment':
      // Skip comments where the user has been deleted.
      $uid = $row->getSourceProperty('uid');
      if (User::load($uid)) {
        throw new MigrateSkipRowException("User $uid no longer exists");
      }
      break;

    case 'd7_menu_links':
      // Only migrate menu links which are not already in the menu tree
      //use the title to identify menu links
      $title = $row->getSourceProperty('link_title');
      $query = \Drupal::database()->select('menu_tree', 'mt')
        ->fields('mt');
      $query->condition($query->orConditionGroup()
        ->condition('title', serialize(new TranslatableMarkup($title)))
        ->condition('title', serialize($title))
      );
      if ($query->execute()->fetch()) {
        throw new MigrateSkipRowException("Menu link '$title' already exists");
      }
      break;

    case 'd7_theme_settings':
      if (in_array($row->getSourceProperty('name'), ['theme_sky_settings', 'theme_garland_settings']))  {
        return FALSE;
      }
      break;
    case 'contact_category':
      // The category is a machine name taken from the localised d7 category name.
      if (strlen($row->getSourceProperty('category')) > 32) {
        return FALSE;
      }
      break;

    case 'd7_block':
      $ignoreDeltas = ['visitors', 'secondary-menu', 'form', 'online'];// the last one is the search form
      $ignoreThemes = ['bartik', 'seven'];
      if (in_array($row->getSourceProperty('delta'), $ignoreDeltas) or in_array($row->getSourceProperty('theme'), $ignoreThemes)) {
        return FALSE;
      }
      break;

    case 'd7_menu':
      if ($row->getSourceProperty('menu_name') == 'devel') {
        return FALSE;
      }
      break;

    case 'd7_comment_field':
      drupal_set_message("_cforge_migrate_prepare_row: Skipping row with sourcePluginId d7_comment_field");
    case 'd7_comment_type':
    case 'd7_node_title_label':
    case 'block_content_type':
    case 'block_content_entity_display':
      return FALSE;
  }
}
