<?php

/**
 * @file
 * Drupal 7 view with CSV export of members.
 */

$view = new view();
$view->name = 'member_list';
$view->description = 'Member list with alpha pagers,';
$view->tag = 'cforge';
$view->base_table = 'users';
$view->human_name = 'Member list';
$view->core = 0;
$view->api_version = '3.0';
$view->disabled = FALSE; /* Edit this to true to make a default view disabled initially */

/* Display: Defaults */
$handler = $view->new_display('default', 'Defaults', 'default');
$handler->display->display_options['use_more_always'] = FALSE;
$handler->display->display_options['access']['type'] = 'role';
$handler->display->display_options['access']['role'] = array(
  2 => 2,
);
$handler->display->display_options['cache']['type'] = 'none';
$handler->display->display_options['query']['type'] = 'views_query';
$handler->display->display_options['query']['options']['query_comment'] = FALSE;
$handler->display->display_options['exposed_form']['type'] = 'basic';
$handler->display->display_options['pager']['type'] = 'full';
$handler->display->display_options['pager']['options']['items_per_page'] = '25';
$handler->display->display_options['pager']['options']['offset'] = '0';
$handler->display->display_options['pager']['options']['id'] = '0';
$handler->display->display_options['pager']['options']['quantity'] = '100';
$handler->display->display_options['style_plugin'] = 'table';
$handler->display->display_options['style_options']['default_row_class'] = FALSE;
$handler->display->display_options['style_options']['columns'] = array(
  'uid' => 'uid',
  'picture' => 'picture',
  'profile_address_first_name' => 'profile_address_first_name',
  'profile_address_last_name' => 'profile_address_last_name',
  'profile_phones' => 'profile_phones',
  'current_balance' => 'current_balance',
  'current_balance_1' => 'current_balance_1',
  'profile_address_locality' => 'profile_address_locality',
  'limits' => 'limits',
);
$handler->display->display_options['style_options']['default'] = 'profile_address_first_name';
$handler->display->display_options['style_options']['info'] = array(
  'uid' => array(
    'sortable' => 1,
    'default_sort_order' => 'asc',
    'align' => '',
    'separator' => '',
    'empty_column' => 0,
  ),
  'picture' => array(
    'sortable' => 0,
    'default_sort_order' => 'asc',
    'align' => '',
    'separator' => '',
    'empty_column' => 0,
  ),
  'profile_address_first_name' => array(
    'sortable' => 1,
    'default_sort_order' => 'asc',
    'align' => '',
    'separator' => '',
    'empty_column' => 0,
  ),
  'profile_address_last_name' => array(
    'sortable' => 1,
    'default_sort_order' => 'asc',
    'align' => '',
    'separator' => '',
    'empty_column' => 0,
  ),
  'profile_phones' => array(
    'align' => '',
    'separator' => '',
    'empty_column' => 0,
  ),
  'current_balance' => array(
    'align' => '',
    'separator' => '',
    'empty_column' => 0,
  ),
  'current_balance_1' => array(
    'align' => '',
    'separator' => '',
    'empty_column' => 0,
  ),
  'profile_address_locality' => array(
    'sortable' => 1,
    'default_sort_order' => 'asc',
    'align' => '',
    'separator' => '',
    'empty_column' => 0,
  ),
  'limits' => array(
    'align' => '',
    'separator' => '',
    'empty_column' => 0,
  ),
);
$handler->display->display_options['style_options']['override'] = FALSE;
$handler->display->display_options['style_options']['sticky'] = TRUE;
/* Relationship: File Usage: File */
$handler->display->display_options['relationships']['user_to_file']['id'] = 'user_to_file';
$handler->display->display_options['relationships']['user_to_file']['table'] = 'file_usage';
$handler->display->display_options['relationships']['user_to_file']['field'] = 'user_to_file';
/* Field: User: Uid */
$handler->display->display_options['fields']['uid']['id'] = 'uid';
$handler->display->display_options['fields']['uid']['table'] = 'users';
$handler->display->display_options['fields']['uid']['field'] = 'uid';
$handler->display->display_options['fields']['uid']['label'] = 'N°';
/* Field: User: Picture */
$handler->display->display_options['fields']['picture']['id'] = 'picture';
$handler->display->display_options['fields']['picture']['table'] = 'users';
$handler->display->display_options['fields']['picture']['field'] = 'picture';
$handler->display->display_options['fields']['picture']['label'] = '';
/* Field: User: Name &amp; Address - First name */
$handler->display->display_options['fields']['profile_address_first_name']['id'] = 'profile_address_first_name';
$handler->display->display_options['fields']['profile_address_first_name']['table'] = 'field_data_profile_address';
$handler->display->display_options['fields']['profile_address_first_name']['field'] = 'profile_address_first_name';
$handler->display->display_options['fields']['profile_address_first_name']['label'] = 'First name';
/* Field: User: Name &amp; Address - Last name */
$handler->display->display_options['fields']['profile_address_last_name']['id'] = 'profile_address_last_name';
$handler->display->display_options['fields']['profile_address_last_name']['table'] = 'field_data_profile_address';
$handler->display->display_options['fields']['profile_address_last_name']['field'] = 'profile_address_last_name';
$handler->display->display_options['fields']['profile_address_last_name']['label'] = 'Last name';
/* Field: User: Phone Numbers */
$handler->display->display_options['fields']['profile_phones']['id'] = 'profile_phones';
$handler->display->display_options['fields']['profile_phones']['table'] = 'field_data_profile_phones';
$handler->display->display_options['fields']['profile_phones']['field'] = 'profile_phones';
/* Field: User: Transaction statistic */
$handler->display->display_options['fields']['current_balance']['id'] = 'current_balance';
$handler->display->display_options['fields']['current_balance']['table'] = 'users';
$handler->display->display_options['fields']['current_balance']['field'] = 'current_balance';
$handler->display->display_options['fields']['current_balance']['label'] = 'Balance';
$handler->display->display_options['fields']['current_balance']['currcode'] = array(
  'credunit' => 'credunit',
);
/* Field: User: Transaction statistic */
$handler->display->display_options['fields']['current_balance_1']['id'] = 'current_balance_1';
$handler->display->display_options['fields']['current_balance_1']['table'] = 'users';
$handler->display->display_options['fields']['current_balance_1']['field'] = 'current_balance';
$handler->display->display_options['fields']['current_balance_1']['label'] = 'Gross Income';
$handler->display->display_options['fields']['current_balance_1']['currcode'] = array(
  'credunit' => 'credunit',
);
$handler->display->display_options['fields']['current_balance_1']['total'] = 'gross_in';
/* Field: User: Neighbourhood */
$handler->display->display_options['fields']['profile_address_locality']['id'] = 'profile_address_dependent_locality';
$handler->display->display_options['fields']['profile_address_locality']['table'] = 'field_data_profile_address';
$handler->display->display_options['fields']['profile_address_locality']['field'] = 'profile_address_dependent_locality';
/* Filter criterion: User: Active */
$handler->display->display_options['filters']['status']['id'] = 'status';
$handler->display->display_options['filters']['status']['table'] = 'users';
$handler->display->display_options['filters']['status']['field'] = 'status';
$handler->display->display_options['filters']['status']['value'] = '1';
$handler->display->display_options['filters']['status']['group'] = '0';
$handler->display->display_options['filters']['status']['expose']['operator'] = FALSE;
/* Filter criterion: User: Roles */
$handler->display->display_options['filters']['rid']['id'] = 'rid';
$handler->display->display_options['filters']['rid']['table'] = 'users_roles';
$handler->display->display_options['filters']['rid']['field'] = 'rid';
$handler->display->display_options['filters']['rid']['operator'] = 'not';
$handler->display->display_options['filters']['rid']['value'] = array(
  7 => '7',
);
$handler->display->display_options['filters']['rid']['group'] = '0';
$handler->display->display_options['filters']['rid']['expose']['operator'] = FALSE;

/* Display: CSV export */
$handler = $view->new_display('views_data_export', 'CSV export', 'views_data_export_1');
$handler->display->display_options['defaults']['title'] = FALSE;
$handler->display->display_options['title'] = 'All active users';
$handler->display->display_options['defaults']['hide_admin_links'] = FALSE;
$handler->display->display_options['defaults']['access'] = FALSE;
$handler->display->display_options['access']['type'] = 'role';
$handler->display->display_options['access']['role'] = array(
  4 => 4,
);
$handler->display->display_options['pager']['type'] = 'none';
$handler->display->display_options['pager']['options']['offset'] = '0';
$handler->display->display_options['style_plugin'] = 'views_data_export_csv';
$handler->display->display_options['style_options']['provide_file'] = 1;
$handler->display->display_options['style_options']['filename'] = 'members.csv';
$handler->display->display_options['style_options']['parent_sort'] = 0;
$handler->display->display_options['style_options']['quote'] = 1;
$handler->display->display_options['style_options']['trim'] = 0;
$handler->display->display_options['style_options']['replace_newlines'] = 1;
$handler->display->display_options['style_options']['newline_replacement'] = '\\n';
$handler->display->display_options['style_options']['header'] = 1;
$handler->display->display_options['defaults']['fields'] = FALSE;
/* Field: User: Name */
$handler->display->display_options['fields']['name']['id'] = 'name';
$handler->display->display_options['fields']['name']['table'] = 'users';
$handler->display->display_options['fields']['name']['field'] = 'name';
$handler->display->display_options['fields']['name']['label'] = 'name';
$handler->display->display_options['fields']['name']['link_to_user'] = FALSE;
/* Field: User: E-mail */
$handler->display->display_options['fields']['mail']['id'] = 'mail';
$handler->display->display_options['fields']['mail']['table'] = 'users';
$handler->display->display_options['fields']['mail']['field'] = 'mail';
$handler->display->display_options['fields']['mail']['label'] = 'mail';
$handler->display->display_options['fields']['mail']['link_to_user'] = '0';
/* Field: User: Responsibility */
$handler->display->display_options['fields']['manage_responsibility']['id'] = 'manage_responsibility';
$handler->display->display_options['fields']['manage_responsibility']['table'] = 'field_data_manage_responsibility';
$handler->display->display_options['fields']['manage_responsibility']['field'] = 'manage_responsibility';
$handler->display->display_options['fields']['manage_responsibility']['label'] = 'roles';
/* Field: User: Name & Address */
$handler->display->display_options['fields']['profile_address']['id'] = 'profile_address';
$handler->display->display_options['fields']['profile_address']['table'] = 'field_data_profile_address';
$handler->display->display_options['fields']['profile_address']['field'] = 'profile_address';
$handler->display->display_options['fields']['profile_address']['label'] = 'firstname';
$handler->display->display_options['fields']['profile_address']['alter']['alter_text'] = TRUE;
$handler->display->display_options['fields']['profile_address']['alter']['text'] = '[profile_address-first_name]';
$handler->display->display_options['fields']['profile_address']['click_sort_column'] = 'country';
$handler->display->display_options['fields']['profile_address']['settings'] = array(
  'use_widget_handlers' => 1,
  'format_handlers' => array(
    'address' => 'address',
  ),
);
/* Field: User: Name & Address */
$handler->display->display_options['fields']['profile_address_1']['id'] = 'profile_address_1';
$handler->display->display_options['fields']['profile_address_1']['table'] = 'field_data_profile_address';
$handler->display->display_options['fields']['profile_address_1']['field'] = 'profile_address';
$handler->display->display_options['fields']['profile_address_1']['label'] = 'lastname';
$handler->display->display_options['fields']['profile_address_1']['alter']['alter_text'] = TRUE;
$handler->display->display_options['fields']['profile_address_1']['alter']['text'] = '[profile_address_1-last_name]';
$handler->display->display_options['fields']['profile_address_1']['click_sort_column'] = 'country';
$handler->display->display_options['fields']['profile_address_1']['settings'] = array(
  'use_widget_handlers' => 1,
  'format_handlers' => array(
    'address' => 'address',
  ),
);
/* Field: User: Created date */
$handler->display->display_options['fields']['created']['id'] = 'created';
$handler->display->display_options['fields']['created']['table'] = 'users';
$handler->display->display_options['fields']['created']['field'] = 'created';
$handler->display->display_options['fields']['created']['label'] = 'created';
$handler->display->display_options['fields']['created']['date_format'] = 'custom';
$handler->display->display_options['fields']['created']['custom_date_format'] = 'd-m-Y';
$handler->display->display_options['fields']['created']['second_date_format'] = 'long';
/* Field: User: Last access */
$handler->display->display_options['fields']['access']['id'] = 'access';
$handler->display->display_options['fields']['access']['table'] = 'users';
$handler->display->display_options['fields']['access']['field'] = 'access';
$handler->display->display_options['fields']['access']['label'] = 'access';
$handler->display->display_options['fields']['access']['date_format'] = 'custom';
$handler->display->display_options['fields']['access']['custom_date_format'] = 'd-m-Y';
$handler->display->display_options['fields']['access']['second_date_format'] = 'long';
/* Field: User: Transaction statistic */
$handler->display->display_options['fields']['current_balance']['id'] = 'current_balance';
$handler->display->display_options['fields']['current_balance']['table'] = 'users';
$handler->display->display_options['fields']['current_balance']['field'] = 'current_balance';
$handler->display->display_options['fields']['current_balance']['label'] = 'Balance';
$handler->display->display_options['fields']['current_balance']['strip'] = 1;
/* Field: User: Transaction statistic */
$handler->display->display_options['fields']['current_balance_1']['id'] = 'current_balance_1';
$handler->display->display_options['fields']['current_balance_1']['table'] = 'users';
$handler->display->display_options['fields']['current_balance_1']['field'] = 'current_balance';
$handler->display->display_options['fields']['current_balance_1']['label'] = 'Gross income';
$handler->display->display_options['fields']['current_balance_1']['total'] = 'gross_in';
$handler->display->display_options['fields']['current_balance_1']['strip'] = 1;
/* Field: User: Name & Address */
$handler->display->display_options['fields']['profile_address_2']['id'] = 'profile_address_2';
$handler->display->display_options['fields']['profile_address_2']['table'] = 'field_data_profile_address';
$handler->display->display_options['fields']['profile_address_2']['field'] = 'profile_address';
$handler->display->display_options['fields']['profile_address_2']['label'] = 'address.line1';
$handler->display->display_options['fields']['profile_address_2']['alter']['alter_text'] = TRUE;
$handler->display->display_options['fields']['profile_address_2']['alter']['text'] = '[profile_address_2-thoroughfare]';
$handler->display->display_options['fields']['profile_address_2']['click_sort_column'] = 'country';
$handler->display->display_options['fields']['profile_address_2']['settings'] = array(
  'use_widget_handlers' => 1,
  'format_handlers' => array(
    'address' => 'address',
  ),
);
/* Field: User: Name & Address */
$handler->display->display_options['fields']['profile_address_5']['id'] = 'profile_address_5';
$handler->display->display_options['fields']['profile_address_5']['table'] = 'field_data_profile_address';
$handler->display->display_options['fields']['profile_address_5']['field'] = 'profile_address';
$handler->display->display_options['fields']['profile_address_5']['label'] = 'address.line2';
$handler->display->display_options['fields']['profile_address_5']['alter']['alter_text'] = TRUE;
$handler->display->display_options['fields']['profile_address_5']['alter']['text'] = '[profile_address_5-thoroughfare]';
$handler->display->display_options['fields']['profile_address_5']['element_default_classes'] = FALSE;
$handler->display->display_options['fields']['profile_address_5']['click_sort_column'] = 'country';
$handler->display->display_options['fields']['profile_address_5']['settings'] = array(
  'use_widget_handlers' => 0,
  'format_handlers' => array(),
);
/* Field: User: Name &amp; Address - Company */
$handler->display->display_options['fields']['profile_address_organisation_name']['id'] = 'profile_address_organisation_name';
$handler->display->display_options['fields']['profile_address_organisation_name']['table'] = 'field_data_profile_address';
$handler->display->display_options['fields']['profile_address_organisation_name']['field'] = 'profile_address_organisation_name';
$handler->display->display_options['fields']['profile_address_organisation_name']['label'] = 'address.organization';
/* Field: User: Name & Address */
$handler->display->display_options['fields']['profile_address_3']['id'] = 'profile_address_3';
$handler->display->display_options['fields']['profile_address_3']['table'] = 'field_data_profile_address';
$handler->display->display_options['fields']['profile_address_3']['field'] = 'profile_address';
$handler->display->display_options['fields']['profile_address_3']['label'] = 'address.dependent_locality';
$handler->display->display_options['fields']['profile_address_3']['alter']['alter_text'] = TRUE;
$handler->display->display_options['fields']['profile_address_3']['alter']['text'] = '[profile_address_3-dependent_locality]';
$handler->display->display_options['fields']['profile_address_3']['click_sort_column'] = 'country';
$handler->display->display_options['fields']['profile_address_3']['settings'] = array(
  'use_widget_handlers' => 1,
  'format_handlers' => array(
    'address' => 'address',
  ),
);
/* Field: User: Name &amp; Address - Locality (i.e. City) */
$handler->display->display_options['fields']['profile_address_locality']['id'] = 'profile_address_locality';
$handler->display->display_options['fields']['profile_address_locality']['table'] = 'field_data_profile_address';
$handler->display->display_options['fields']['profile_address_locality']['field'] = 'profile_address_locality';
$handler->display->display_options['fields']['profile_address_locality']['label'] = 'address.locality';
/* Field: User: Name &amp; Address - Administrative area (i.e. State / Province) */
$handler->display->display_options['fields']['profile_address_administrative_area']['id'] = 'profile_address_administrative_area';
$handler->display->display_options['fields']['profile_address_administrative_area']['table'] = 'field_data_profile_address';
$handler->display->display_options['fields']['profile_address_administrative_area']['field'] = 'profile_address_administrative_area';
$handler->display->display_options['fields']['profile_address_administrative_area']['label'] = 'address.administrative_area';
$handler->display->display_options['fields']['profile_address_administrative_area']['display_name'] = 1;
/* Field: User: Name &amp; Address - Country */
$handler->display->display_options['fields']['profile_address_country']['id'] = 'profile_address_country';
$handler->display->display_options['fields']['profile_address_country']['table'] = 'field_data_profile_address';
$handler->display->display_options['fields']['profile_address_country']['field'] = 'profile_address_country';
$handler->display->display_options['fields']['profile_address_country']['label'] = 'address.country_code';
$handler->display->display_options['fields']['profile_address_country']['exclude'] = TRUE;
$handler->display->display_options['fields']['profile_address_country']['element_label_colon'] = FALSE;
$handler->display->display_options['fields']['profile_address_country']['display_name'] = 0;
/* Field: User: Name & Address */
$handler->display->display_options['fields']['profile_address_4']['id'] = 'profile_address_4';
$handler->display->display_options['fields']['profile_address_4']['table'] = 'field_data_profile_address';
$handler->display->display_options['fields']['profile_address_4']['field'] = 'profile_address';
$handler->display->display_options['fields']['profile_address_4']['label'] = 'address.postalcode';
$handler->display->display_options['fields']['profile_address_4']['alter']['alter_text'] = TRUE;
$handler->display->display_options['fields']['profile_address_4']['alter']['text'] = '[profile_address_4-postal_code]';
$handler->display->display_options['fields']['profile_address_4']['click_sort_column'] = 'country';
$handler->display->display_options['fields']['profile_address_4']['settings'] = array(
  'use_widget_handlers' => 1,
  'format_handlers' => array(
    'address' => 'address',
  ),
);
/* Field: User: Phone Numbers */
$handler->display->display_options['fields']['profile_phones']['id'] = 'profile_phones';
$handler->display->display_options['fields']['profile_phones']['table'] = 'field_data_profile_phones';
$handler->display->display_options['fields']['profile_phones']['field'] = 'profile_phones';
$handler->display->display_options['fields']['profile_phones']['label'] = 'phones';
$handler->display->display_options['fields']['profile_phones']['delta_offset'] = '0';
/* Field: User: Phone Numbers */
$handler->display->display_options['fields']['profile_phones_1']['id'] = 'profile_phones_1';
$handler->display->display_options['fields']['profile_phones_1']['table'] = 'field_data_profile_phones';
$handler->display->display_options['fields']['profile_phones_1']['field'] = 'profile_phones';
$handler->display->display_options['fields']['profile_phones_1']['label'] = 'phones2';
$handler->display->display_options['fields']['profile_phones_1']['delta_offset'] = '0';
/* Field: User: What would you do if there was enough money? */
$handler->display->display_options['fields']['profile_notes']['id'] = 'profile_notes';
$handler->display->display_options['fields']['profile_notes']['table'] = 'field_data_profile_notes';
$handler->display->display_options['fields']['profile_notes']['field'] = 'profile_notes';
$handler->display->display_options['fields']['profile_notes']['label'] = 'notes';
/* Field: User: Notes (The user cannot see these) */
$handler->display->display_options['fields']['manage_notes']['id'] = 'manage_notes';
$handler->display->display_options['fields']['manage_notes']['table'] = 'field_data_manage_notes';
$handler->display->display_options['fields']['manage_notes']['field'] = 'manage_notes';
$handler->display->display_options['fields']['manage_notes']['label'] = 'notes_admin';
$handler->display->display_options['fields']['manage_notes']['type'] = 'text_plain';
/* Field: File: Path */
$handler->display->display_options['fields']['uri']['id'] = 'uri';
$handler->display->display_options['fields']['uri']['table'] = 'file_managed';
$handler->display->display_options['fields']['uri']['field'] = 'uri';
$handler->display->display_options['fields']['uri']['relationship'] = 'user_to_file';
$handler->display->display_options['fields']['uri']['label'] = 'user_picture';
$handler->display->display_options['fields']['uri']['file_download_path'] = TRUE;
$handler->display->display_options['defaults']['filter_groups'] = FALSE;
$handler->display->display_options['defaults']['filters'] = FALSE;
/* Filter criterion: User: Active */
$handler->display->display_options['filters']['status']['id'] = 'status';
$handler->display->display_options['filters']['status']['table'] = 'users';
$handler->display->display_options['filters']['status']['field'] = 'status';
$handler->display->display_options['filters']['status']['value'] = '1';
$handler->display->display_options['filters']['status']['group'] = '0';
$handler->display->display_options['filters']['status']['expose']['operator'] = FALSE;
$handler->display->display_options['path'] = 'members.csv';
$handler->display->display_options['displays'] = array(
  'page_1' => 'page_1',
  'page_2' => 'page_2',
  'default' => 0,
);
$handler->display->display_options['use_batch'] = 'batch';
