<?php
/**
 * @file
 * D7 view which provides transactions csv suitable for import.
 */

$view = new view();
$view->name = 'test';
$view->description = '';
$view->tag = 'mcapi';
$view->base_table = 'mcapi_transactions';
$view->human_name = 'Export csv to hamlets d8';
$view->core = 7;
$view->api_version = '3.0';
$view->disabled = FALSE; /* Edit this to true to make a default view disabled initially */

/* Display: Master */
$handler = $view->new_display('default', 'Master', 'default');
$handler->display->display_options['use_more_always'] = FALSE;
$handler->display->display_options['access']['type'] = 'none';
$handler->display->display_options['cache']['type'] = 'none';
$handler->display->display_options['query']['type'] = 'views_query';
$handler->display->display_options['exposed_form']['type'] = 'basic';
$handler->display->display_options['pager']['type'] = 'none';
$handler->display->display_options['pager']['options']['offset'] = '0';
$handler->display->display_options['style_plugin'] = 'views_data_export_csv';
$handler->display->display_options['style_options']['provide_file'] = 1;
$handler->display->display_options['style_options']['filename'] = 'transactions.csv';
$handler->display->display_options['style_options']['parent_sort'] = 0;
$handler->display->display_options['style_options']['quote'] = 1;
$handler->display->display_options['style_options']['trim'] = 0;
$handler->display->display_options['style_options']['replace_newlines'] = 1;
$handler->display->display_options['style_options']['newline_replacement'] = '\\n';
$handler->display->display_options['style_options']['header'] = 1;
/* Relationship: Transaction: Payee */
$handler->display->display_options['relationships']['payee']['id'] = 'payee';
$handler->display->display_options['relationships']['payee']['table'] = 'mcapi_transactions';
$handler->display->display_options['relationships']['payee']['field'] = 'payee';
$handler->display->display_options['relationships']['payee']['required'] = TRUE;
/* Relationship: Transaction: Payer */
$handler->display->display_options['relationships']['payer']['id'] = 'payer';
$handler->display->display_options['relationships']['payer']['table'] = 'mcapi_transactions';
$handler->display->display_options['relationships']['payer']['field'] = 'payer';
$handler->display->display_options['relationships']['payer']['required'] = TRUE;
/* Field: Transaction: Created */
$handler->display->display_options['fields']['created']['id'] = 'created';
$handler->display->display_options['fields']['created']['table'] = 'mcapi_transactions';
$handler->display->display_options['fields']['created']['field'] = 'created';
$handler->display->display_options['fields']['created']['label'] = 'created';
$handler->display->display_options['fields']['created']['date_format'] = 'custom';
$handler->display->display_options['fields']['created']['custom_date_format'] = 'd-m-Y';
$handler->display->display_options['fields']['created']['second_date_format'] = 'long';
/* Field: Transaction: Serial */
$handler->display->display_options['fields']['serial']['id'] = 'serial';
$handler->display->display_options['fields']['serial']['table'] = 'mcapi_transactions';
$handler->display->display_options['fields']['serial']['field'] = 'serial';
$handler->display->display_options['fields']['serial']['label'] = 'serial';
$handler->display->display_options['fields']['serial']['element_label_colon'] = FALSE;
$handler->display->display_options['fields']['serial']['link_to_transaction'] = 0;
/* Field: User: E-mail */
$handler->display->display_options['fields']['mail_1']['id'] = 'mail_1';
$handler->display->display_options['fields']['mail_1']['table'] = 'users';
$handler->display->display_options['fields']['mail_1']['field'] = 'mail';
$handler->display->display_options['fields']['mail_1']['relationship'] = 'payer';
$handler->display->display_options['fields']['mail_1']['label'] = 'payer';
$handler->display->display_options['fields']['mail_1']['link_to_user'] = '0';
/* Field: User: E-mail */
$handler->display->display_options['fields']['mail']['id'] = 'mail';
$handler->display->display_options['fields']['mail']['table'] = 'users';
$handler->display->display_options['fields']['mail']['field'] = 'mail';
$handler->display->display_options['fields']['mail']['relationship'] = 'payee';
$handler->display->display_options['fields']['mail']['label'] = 'payee';
$handler->display->display_options['fields']['mail']['link_to_user'] = '0';
/* Field: Transaction: Worth */
$handler->display->display_options['fields']['worth']['id'] = 'worth';
$handler->display->display_options['fields']['worth']['table'] = 'field_data_worth';
$handler->display->display_options['fields']['worth']['field'] = 'worth';
$handler->display->display_options['fields']['worth']['label'] = 'quantity';
$handler->display->display_options['fields']['worth']['element_default_classes'] = FALSE;
$handler->display->display_options['fields']['worth']['hide_alter_empty'] = FALSE;
$handler->display->display_options['fields']['worth']['click_sort_column'] = 'currcode';
$handler->display->display_options['fields']['worth']['type'] = 'worth_numeric';
/* Field: Transaction: Description */
$handler->display->display_options['fields']['transaction_description']['id'] = 'transaction_description';
$handler->display->display_options['fields']['transaction_description']['table'] = 'field_data_transaction_description';
$handler->display->display_options['fields']['transaction_description']['field'] = 'transaction_description';
$handler->display->display_options['fields']['transaction_description']['label'] = 'description';
$handler->display->display_options['fields']['transaction_description']['alter']['make_link'] = TRUE;
$handler->display->display_options['fields']['transaction_description']['alter']['path'] = 'transaction/[serial]';
$handler->display->display_options['fields']['transaction_description']['element_label_colon'] = FALSE;
$handler->display->display_options['fields']['transaction_description']['type'] = 'text_plain';
$handler->display->display_options['fields']['transaction_description']['settings'] = array(
  'trim_length' => '600',
);
/* Field: Transaction: State */
$handler->display->display_options['fields']['state']['id'] = 'state';
$handler->display->display_options['fields']['state']['table'] = 'mcapi_transactions';
$handler->display->display_options['fields']['state']['field'] = 'state';
$handler->display->display_options['fields']['state']['label'] = 'state';
$handler->display->display_options['fields']['state']['element_label_colon'] = FALSE;
$handler->display->display_options['fields']['state']['state_name'] = 0;
/* Field: Transaction: Type */
$handler->display->display_options['fields']['type']['id'] = 'type';
$handler->display->display_options['fields']['type']['table'] = 'mcapi_transactions';
$handler->display->display_options['fields']['type']['field'] = 'type';
$handler->display->display_options['fields']['type']['label'] = 'type';
$handler->display->display_options['fields']['type']['element_label_colon'] = FALSE;
/* Sort criterion: Transaction: Created */
$handler->display->display_options['sorts']['created']['id'] = 'created';
$handler->display->display_options['sorts']['created']['table'] = 'mcapi_transactions';
$handler->display->display_options['sorts']['created']['field'] = 'created';
$handler->display->display_options['sorts']['created']['order'] = 'DESC';
$handler->display->display_options['sorts']['created']['granularity'] = 'minute';

/* Display: Data export */
$handler = $view->new_display('views_data_export', 'Data export', 'views_data_export_1');
$handler->display->display_options['pager']['type'] = 'some';
$handler->display->display_options['style_plugin'] = 'views_data_export_csv';
$handler->display->display_options['path'] = 'transactions.csv';
$handler->display->display_options['use_batch'] = 'batch';
$handler->display->display_options['segment_size'] = '100';
$translatables['test'] = array(
  t('Master'),
  t('more'),
  t('Apply'),
  t('Reset'),
  t('Sort by'),
  t('Asc'),
  t('Desc'),
  t('Payee'),
  t('Payer'),
  t('created'),
  t('serial'),
  t('payer'),
  t('payee'),
  t('quantity'),
  t('description'),
  t('state'),
  t('type'),
  t('Data export'),
);
