<?php

namespace Drupal\ces;

use Drupal\Core\Form\FormStateInterface;
use Drupal\cforge\cforge_import\Launch as BaseLaunch;

/**
 * Form to mail all users with new password.
 */
class Launch extends BaseLaunch {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'ces_launch_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildform(array $form, FormStateInterface $form_state) {
    drupal_set_message(t('This page can be used once only. It will mail every user optionally with a password reset link, notify CES to divert all traffic to this site.'));
    drupal_set_message(t('Coordinate with Tim Jenkin to ensure users do not visit the old site after launch'));
    $form = parent::buildForm($form, $form_state);
    $form['body']['#description'] .= ' ' . $this->t("(The 'account-name' is the code for logging in.)");
    $form['notify_tim'] = [
      '#title' => $this->t('Notify Tim Jenkin asking him to redirect to @name'),
      '#type' => 'checkbox',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function submit($form, FormStateInterface $form_state) {
    parent::submit($form, $form_state);
    if ($form_state->getValue('notify_tim')) {
      $code = \Drupal::config('ces.settings')->get('code');
      $url = $_SERVER['HTTP_HOST'];
      $message = "Dear Tim,
  Please redirect site '$code' to @url.";
      mail('tim@ces.org.za', 'CES migration to Hamlets', $message);
    }
  }

}
