<?php

namespace Drupal\ces\Plugin\CsvParser;

use Drupal\cforge_import\Plugin\CsvParser\Smallads;
use Drupal\smallads\Entity\SmallAdInterface;

/**
 * Plugin to import offers.
 *
 * @Plugin(
 *   id = "offers",
 *   label = @translation("Offers"),
 *   type = "offer"
 * )
 */
class Offers extends Smallads {

  const BUNDLE = 'offer';

  /**
   * {@inheritdoc}
   */
  public static function columns() {
    $columns = parent::columns();
    unset($columns['uid']);
    unset($columns['name']);
    return [
      'ces_uid' => t('CES user code (corresponds to Drupal user name)'),
      'categories' => t('comma separated term names'),
      'expires' => t('date of format:  "2016-01-15 19:10:33"'),
    ] + $columns + [
      'picture' => t('file path for downloading'),
    ];
  }

  /**
   * Preprocessing for csv field 'ces_uid'.
   */
  public static function ces_uidProcess(SmallAdInterface $entity, $val, $allfields) {
    $uids = \Drupal::entityQuery('user')
      ->condition('name', $val)
      ->execute();
    if ($uids) {
      $entity->setOwnerId(reset($uids));
    }
    else {
      drupal_set_message(t('Skipped offer owned by unidentified user @name', array('@name' => $val)), 'warning');
    }
  }

}
