<?php

namespace Drupal\ces\Plugin\CsvParser;
use Drupal\mcapi\Entity\Wallet;
use Drupal\mcapi\Entity\TransactionInterface;
use Drupal\user\Entity\User;

/**
 * Plugin to import transactions.
 *
 * @Plugin(
 *   id = "trades",
 *   label = @Translation("Transactions")
 * )
 */
class Transactions extends \Drupal\cforge_import\Plugin\CsvParser\Transactions {

  /**
   * Preprocessing for csv field 'payer'.
   */
  protected static function payerProcess(TransactionInterface $entity, $user_name, $allfields) {
    $entity->payer->target_id = SELF::getWalletId($user_name);
  }

  /**
   * Preprocessing for csv field 'payee'.
   */
  protected static function payeeProcess(TransactionInterface $entity, $user_name, $allfields) {
    $entity->payee->target_id = SELF::getWalletId($user_name);
  }

  /**
   * Preprocessing for csv field 'type'.
   */
  protected static function typeProcess(TransactionInterface $entity, $val, $allfields) {
    // If (strPos($allfields['description'], ''))
    $entity->type->target_id  = strtolower($val);
  }

  /**
   * Helper.
   */
  private static function getWalletId($user_name) {
    static $allwallets;
    if (!isset($allwallets[$user_name])) {
      // Assumes no two wallet names are the same.
      $users = \Drupal::entityTypeManager()->getStorage('user')
        ->loadByProperties(['name' => $user_name]);
      if ($users) {
        $wids = \Drupal\mcapi\Storage\WalletStorage::walletsOf(reset($users));
        $allwallets[$user_name] = reset($wids);
      }
      else {
        // Create a new wallet, owned by user 1.
        $wallet = Wallet::create(
          ['name' => $user_name, 'orphaned' => TRUE, 'created' => 0, 'holder' => User::load(1)]
        );
        $wallet->save();
        $allwallets[$user_name] = $wallet->id();
        \Drupal::logger('ces')->debug("Created orphaned wallet for nonexistent user $user_name");
      }
    }
    return $allwallets[$user_name];
  }

}
