<?php

namespace Drupal\ces\Plugin\CsvParser;

use Drupal\cforge_import\Plugin\CsvParser\Users as BaseUsers;
use Drupal\user\UserInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;

/**
 * Plugin to import users.
 *
 * @Plugin(
 *   id = "members",
 *   label = "Users"
 * )
 */
class Users extends BaseUsers implements ContainerFactoryPluginInterface {

  /**
   * {@inheritdoc}
   */
  public static function columns() {
    return parent::columns() + [
      'privacy_phone1' => t('boolean flag for privacy of first phone number'),
      'privacy_phone2' => t('boolean flag for privacy of second phone number'),
      'privacy_address' => t('boolean flag for privacy of first line of address'),
    ];
  }

  /**
   * Batch callback.
   *
   * The sandbox seems to be empty every time, unfortunately.
   */
  public static function saveEntity($row, $test = TRUE) {
    $user = parent::saveEntity($row, $test);
    if ($user->id()) {
      $val = [
        'phone1' => $row['privacy_phone1'],
        'phone2' => $row['privacy_phone2'],
        'address' => $row['privacy_address'],
      ];
      \Drupal::keyValue('user.privacy')->set($user->id(), $val);
    }
    return $user;
  }

  /**
   * Preprocessing for csv field 'coordinator'.
   */
  public static function coordinatorProcess(UserInterface $account, $val, &$allfields) {
    // $account->addRole('superneighbour');.
  }

  /**
   * Preprocessing for csv field 'role'.
   *
   * Possible incoming values are ind|fam|com|org|pub|adm.
   */
  public static function roleProcess(UserInterface $account, $val, &$allfields) {
    if (strlen($allfields['firstname']) > 25 or strlen($allfields['lastname']) > 25) {
      $val = 'org';
      $allfields['address.organization'] = $allfields['firstname'] . $allfields['lastname'];
      $allfields['address.given_name'] = substr($allfields['firstname'], 0, 25);
      $allfields['address.family_name'] = substr($allfields['lastname'], 0, 25);
    }
    $account->addRole('trader');
    switch ($val) {
      case 'ind':
      case 'fam':
      case 'com':
      case 'org':
        $account->walletType = $val;
        break;

      // Publicly visible wallet permission.
      case 'pub':
        drupal_set_message('public/private wallet setting not yet supported');
        break;

      case 'adm':
        $account->addRole('committee');
        break;

      default:
        throw new Exception('Unknown role: ' . $val);
    }
  }

  /**
   * Preprocessing for csv field 'privacy_phone1'.
   */
  public static function privacy_phone1Process() {}

  /**
   * Preprocessing for csv field 'privacy_phone2'.
   */
  public static function privacy_phone2Process() {}

  /**
   * Preprocessing for csv field 'privacy_address'.
   */
  public static function privacy_addressProcess() {}

}
