<?php

namespace Drupal\ces\Plugin\CsvParser;

use Drupal\cforge_import\Plugin\CsvParser\Smallads;
use Drupal\smallads\Entity\SmallAdInterface;

/**
 * Plugin to import wants.
 *
 * @Plugin(
 *   id = "wants",
 *   label = @translation("Wants"),
 *   type = "want"
 * )
 */
class Wants extends Smallads {

  const BUNDLE = 'want';

  /**
   * {@inheritdoc}
   */
  public static function columns() {
    $columns = parent::columns();
    unset($columns['uid']);
    return [
      'ces_uid' => t('CES user code (corresponds to Drupal user name)'),
    ] + $columns;
  }

  /**
   * {@inheritdoc}
   */
  public static function ces_uidProcess(SmallAdInterface $entity, $val, $allfields) {
    $uids = \Drupal::entityQuery('user')
      ->condition('name', $val)
      ->execute();
    if ($uids) {
      $entity->setOwnerId(reset($uids));
    }
    else {
      drupal_set_message(t('Skipped offer owned by unidentified user @name', array('@name' => $val)), 'warning');
    }
  }

}
