<?php

namespace Drupal\ces;

use Drupal\mcapi\Entity\Transaction;
use Drupal\mcapi\Event\McapiEvents;
use Drupal\mcapi\Event\TransactionAssembleEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Supplements every transaction with another payment of 2%.
 */
class TransactionSubscriber implements EventSubscriberInterface {

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    return [
      McapiEvents::ASSEMBLE => ['onmakeChildren'],
      // ,McapiEvents::ACTION => ['onTransactionAction'].
    ];
  }

  /**
   * This is an example for now, but it mightMcapi work with rules later on.
   *
   * @param TransactionAssembleEvent $event
   *   The event.
   */
  public function onMakeChildren(TransactionAssembleEvent $event) {
    $transaction = $event->getSubject();
    $fees = \Drupal::config('mcapi.fees');
    if (!$fees->get('rate')) {
      return;
    }
    if ($transaction->type->target_id != 'default') {
      return;
    }
    if ($fees->get('payer')) {
      $payers[] = $transaction->payer->target_id;
    }
    if ($fees->get('payee')) {
      $payers[] = $transaction->payee->target_id;
    }

    $current_value = $transaction->worth->{$fees->get('curr_id')};
    $temp = $current_value * $fees->get('rate');
    $levy_value = $fees->get('round_up') ? ceil($temp / 100) : floor($temp / 100);

    foreach ($payers as $payer) {
      if ($payer == $fees->get('target')) {
        continue;
      }
      $props = [
        // User id.
        'creator' => 1,
        // References \Drupal\mcapi\Entity\Type.
        'type' => 'auto',
        'worth' => [
          0 => [
            'curr_id' => $fees->get('curr_id'),
            'value' => $levy_value,
          ],
        ],
        //Wallet IDs
        'payer' => $payer,
        'payee' => $fees->get('target'),
        // $fees->get('description')
        'description' => 'Levy',
      ];
      $child = Transaction::create($props + ['payer' => $transaction->payer->target_id]);
      $event->addChild($child);
    }

  }

}
