<?php

namespace Drupal\cforge_broadcast\Plugin\QueueWorker;

use Drupal\Core\Queue\QueueWorkerBase;

/**
 * Updates a feed's items.
 *
 * @QueueWorker(
 *   id = "cforge_autonews",
 *   title = @Translation("Cforge auto-news"),
 *   cron = {"time" = 60}
 * )
 */
class AutoNews extends QueueWorkerBase {

  /**
   * {@inheritdoc}
   */
  public function processItem($data) {
    $account = user_load($data['uid']);
    drupal_mail(
      'cforge_broadcast',
      'autonews',
      $account->mail,
      user_preferred_language($account),
      [
        'user' => $account,
        'since' => $data['since'],
      ]
    );

  }

}
