<?php

/**
 * @file
 * Contains \Drupal\community_tasks\Form\CommitToTask.
 */

namespace Drupal\community_tasks\Form;

use \Drupal\Core\Form\FormBase;
use \Drupal\Core\Form\FormStateInterface;
use \Drupal\Node\Entity\Node;

/**
 * Builds a form to change the owner of a community task
 */
class CommitToTask extends FormBase {

  /**
   * {@inheritdoc}
   */
  function getFormId() {
    return 'commit_to_task';
  }
  
  /**
   * {@inheritdoc}
   */
  function buildForm(array $form, FormStateInterface $form_state) {
    $form['nid'] = [
      '#type' => 'hidden',
      '#default_value' => $form_state->getBuildInfo()['args'][0]->id(),
    ];
    $form['submit'] = [
      '#type' => 'submit',
      '#value' => t('Commit to this task'),
    ];
    return $form;
  }
  
  /**
   * {@inheritdoc}
   */
  function submitForm(array &$form, FormStateInterface $form_state) {
    $nid = $form_state->getValue('nid');
    
    Node::load($nid)
      ->setOwnerId(\Drupal::currentuser()->id())
      ->save();
    
    $form_state->setRedirect(
      'entity.node.canonical', 
      ['node' => $nid]
    );
  }

}
