<?php

/**
 * @file
 * Contains \Drupal\community_tasks\Form\SignTask.
 */

namespace Drupal\community_tasks\Form;

use \Drupal\Core\Form\FormBase;
use \Drupal\Core\Form\FormStateInterface;
use \Drupal\Node\Entity\Node;

/**
 * Builds a form to promote a community task node
 */
class SignTask extends FormBase {

  /**
   * {@inheritdoc}
   */
  function getFormId() {
    return 'sign_task';
  }
  
  /**
   * {@inheritdoc}
   */
  function buildForm(array $form, FormStateInterface $form_state) {
    $form['nid'] = [
      '#type' => 'hidden',
      '#default_value' => $form_state->getBuildInfo()['args'][0]->id(),
    ];
    $form['submit'] = [
      '#type' => 'submit',
      '#value' => t('Mark this task completed'),
    ];
    return $form;
  }
  
  /**
   * {@inheritdoc}
   */
  function submitForm(array &$form, FormStateInterface $form_state) {
    $node = Node::load($form_state->getValue('nid'));
    $node->setPromoted(TRUE)->save();

    //$form_state['redirect'] = 'user/'. $node->uid .'/acknowledgements';
    $form_state->setRedirect(
      'entity.user.canonical',
      ['user' => $node->getOwnerId()]
    );
    //@todo - the equivalient in d8
    //foreach (trigger_get_assigned_actions('community_task_completed') as $aid => $info) {
    //  actions_do($aid, $node, ['group' => 'node', 'hook' => 'community_task_completed']);
    // }
  }

}
