<?php

/**
 * @file
 * Contains \Drupal\community_tasks\Form\UnCommitToTask.
 */

namespace Drupal\community_tasks\Form;

use \Drupal\Core\Form\FormBase;
use \Drupal\Core\Form\FormStateInterface;
use \Drupal\Node\Entity\Node;

/**
 * Builds a form to revert the task owner to user 1
 */
class UnCommitToTask extends FormBase {

  /**
   * {@inheritdoc}
   */
  function getFormId() {
    return 'uncommit_to_task';
  }
  
  /**
   * {@inheritdoc}
   */
  function buildForm(array $form, FormStateInterface $form_state) {
    $form['nid'] = [
      '#type' => 'hidden',
      '#default_value' => $form_state->getBuildInfo()['args'][0]->id(),
    ];

    $form['submit'] = [
      '#type' => 'submit',
      '#value' => t('Un-commit from this task'),
    ];
    return $form;
  }
  
  /**
   * {@inheritdoc}
   */
  function submitForm(array &$form, FormStateInterface $form_state) {
    $nid = $form_state->getValue('nid');
    Node::load($nid)
      ->setOwnerId(1)
      ->save();
    
    $form_state->setRedirect(
      'entity.node.canonical', 
      ['node' => $nid]
    );
    \Drupal::logger('Community Tasks')
      ->notice(
        '@user uncommitted from task @nid'
        [
          '@user' => format_username(user_load($node->uid)),
          '@nid' => $node->nid
        ]
    );
  }

}
