<?php

/**
 * @file
 * Contains \Drupal\geofield\Plugin\GeofieldBackendManager.
 */

namespace Drupal\geofield\Plugin;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;

/**
 * Defines the plugin manager Geofield backends.
 */
class GeofieldBackendManager extends DefaultPluginManager {

  /**
   * Constructs a new \Drupal\geofield\Plugin\GeofieldBackendManager object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/GeofieldBackend', $namespaces, $module_handler, 'Drupal\geofield\Plugin\GeofieldBackendPluginInterface', 'Drupal\geofield\Annotation\GeofieldBackend');

    $this->alterInfo('geofield');
    $this->setCacheBackend($cache_backend, 'geofield_plugins');
  }
}