<?php

namespace Drupal\hamlets\Plugin\Block;
use Drupal\user\Entity\User;
use Drupal\Core\Url;
use Drupal\Core\Block\BlockBase;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides a chit for the current user.
 *
 * @deprecated
 *
 * @Block(
 *   id = "hamlets_current_user",
 *   admin_label = @Translation("Current user chit"),
 *   category = @Translation("Hamlets")
 * )
 */
class CurrentUser extends BlockBase implements ContainerFactoryPluginInterface {

  private $currentUser;
  private $userViewBuilder;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('current_user'),
      $container->get('entity_type.manager')
    );
  }

  /**
   * Constructor.
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition, $current_user, $entity_type_manager) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->currentUser = $current_user;
    $this->userViewBuilder = $entity_type_manager->getViewBuilder('user');
  }

  /**
   * {@inheritdoc}
   */
  public function build() {
    $account = User::load($this->currentUser->id());
    // A renderable array with user portrait image, user name & logout link.
    $settings = [
      'type' => 'image',
      'label' => 'hidden',
      'settings' => ['image_style' => 'thumbnail', 'image_link' => 'none'],
    ];
    $portrait = $account->user_picture->view($settings);print_r($portrait);

    return [
      [
        '#type' => 'link',
        '#title' => render($portrait),
        '#url' => $account->toUrl('canonical'),
        '#attributes' => ['class' => ['portrait']],
        '#options' => ['html' => TRUE],
      ],
      [
        '#type' => 'link',
        '#title' => $account->label(),
        '#url' => $account->toUrl('canonical'),
        '#attributes' => ['class' => ['userlink']],
      ],
      [
        '#type' => 'link',
        '#title' => $this->t('Logout'),
        '#url' => Url::fromRoute('user.logout'),
        '#attributes' => ['class' => ['logoutlink']],
      ],
    ];
  }

}
