<?php

namespace Drupal\hamlets\Plugin\CsvParser;
use Drupal\mcapi\Mcapi;
use Drupal\user\Entity\User;
use Drupal\cforge_import\Plugin\CsvParser\Transactions;
use Drupal\mcapi\Entity\TransactionInterface;

/**
 * Plugin to import transactions.
 *
 * @Plugin(
 *   id = "transactions",
 *   label = @Translation("Transactions")
 * )
 */
class Transactions extends Transactions {

  protected $entityTypeId = 'mcapi_transaction';
  protected $bundle = 'mcapi_transaction';

  private $allWallets = [];

  /**
   * {@inheritdoc}
   */
  public static function columns() {
    $cols = parent::columns();
    $cols['payer'] = t('The email of the payer user');
    $cols['payee'] = t('The email of the payee user');
    $cols['categories'] = t('comma separated category names');
    return $cols;
  }

  /**
   * {@inheritdoc}
   */
  protected function payerProcess(TransactionInterface $entity, $mail, $allfields) {
    $entity->payer->target_id = SELF::firstWalletOfUser($mail);
  }

  /**
   * {@inheritdoc}
   */
  protected function payeeProcess(TransactionInterface $entity, $mail, $allfields) {
    $entity->payee->target_id = SELF::firstWalletOfUser($mail);
  }

  /**
   * Get the first wallet of the given user, identified by email.
   *
   * @param string $mail
   *   Email address of the user.
   */
  private function firstWalletOfUser($mail) {
    static $wids;
    if (!isset($wids[$mail])) {
      $uids = \Drupal::entityQuery('user')->condition('mail', $mail)->execute();
      if (!$uids) {
        throw new \Exception('no user with mail ' . $mail);
      }
      $user = User::load(reset($uids));

      $wids = Mcapi::walletsOf($user);
      if (!$wids) {
        throw new \Exception('no wallet for user ' . $user->id());
      }
      $wids[$mail] = reset($wids);
    }
    return $wids[$mail];
  }

}
