<?php

namespace Drupal\hamlets\Plugin\CsvParser;

use Drupal\cforge_import\Plugin\CsvParser\Users;
use Drupal\user\UserInterface;

/**
 * Plugin to import users.
 *
 * @Plugin(
 *   id = "users",
 *   label = "Users"
 * )
 */
class Users extends Users {

  /**
   * Preprocessing for csv field 'coordinator'.
   */
  public static function coordinatorProcess(UserInterface $account, $val, &$allfields) {
    $account->addRole('superneighbour');
  }

  /**
   * {@inheritdoc}
   */
  public static function saveEntities($rows, $test, &$sandbox) {
    foreach ($rows as $key => $row) {
      if (empty($row['password'])) {
        unset($row[$key]);
      }
    }
    parent::saveEntities($rows, $test, $sandbox);
  }

  /**
   * {@inheritdoc}
   */
  public static function columns() {
    return parent::columns() + [
      // 'grossincome' => t('gross income (instead of transaction import)'),
      // 'balance' => t('current balance (instead of transaction import)')
    ];
  }

}
