<?php

namespace Drupal\hamlets\Plugin\DevelGenerate;
use Drupal\cforge\Plugin\DevelGenerate\CforgeUserGenerate;

/**
 * Provides a UserDevelGenerate plugin.
 *
 * @DevelGenerate(
 *   id = "hamlets_user",
 *   label = @Translation("Users friendly"),
 *   description = @Translation("Generate 26 users with real names."),
 *   url = "user/friendly",
 *   permission = "administer devel_generate",
 *   settings = {
 *     "kill" = FALSE,
 *     "pass" = ""
 *   }
 * )
 */
class HamletsUserGenerate extends CforgeUserGenerate {

  /**
   * {@inheritdoc}
   */
  public function populateUser($account) {
    parent::populateUser($account);
    list($firstname, $lastname)  = $this->demoDataClass->getName();
    $mail = $firstname . '@example.com';
    $account->setEmail($mail);
    $account->init->value = $mail;
    $account->name->value = $firstname . ' ' . $lastname;
    $account->address->given_name = $firstname;
    $account->address->family_name = $lastname;
    $account->present->value = 1;
  }

}
