<?php

namespace Drupal\localexchange\Plugin\DevelGenerate;

use Drupal\cforge\Plugin\DevelGenerate\CforgeUserGenerate;

/**
 * Provides a UserDevelGenerate plugin.
 *
 * @DevelGenerate(
 *   id = "localexchange_user",
 *   label = @Translation("Users friendly"),
 *   description = @Translation("Generate 26 users with real names."),
 *   url = "user/friendly",
 *   permission = "administer devel_generate",
 *   settings = {
 *     "kill" = FALSE,
 *     "pass" = ""
 *   }
 * )
 */
class LocexUserGenerate extends CforgeUserGenerate {

  /**
   * {@inheritdoc}
   */
  public function populateUser($account) {
    parent::populateUser($account);
    list($given_name, $family_name)  = $this->demoDataClass->getName();
    $mail = $given_name . '@example.com';
    $account->setEmail($mail);
    $account->init->value = $mail;
    $account->name->value = $given_name . ' ' . $family_name;
    $account->address->given_name = $given_name;
    $account->address->family_name = $family_name;
    $account->present->value = 1;
  }

}
