<?php

namespace Drupal\masquerade;

use Drupal\Core\Menu\MenuLinkTree;

/**
 * Overrides menu link tree class from Core.
 */
class MasqueradeMenuLinkTree extends MenuLinkTree {

  /**
   * {@inheritdoc}
   */
  public function transform(array $tree, array $manipulators) {
    $tree = parent::transform($tree, $manipulators);
    // Modify the menu tree, removing masquerade.unmasquerade if needed. We do
    // this here so that the link is removed even for user 1 (which access
    // checks on the menu link do not accomplish).
    foreach ($tree as $index => $item) {
      if (strstr($item->link->getRouteName(), 'masquerade.unmasquerade')) {
        $masquerade = \Drupal::service('masquerade');
        if (!$masquerade->isMasquerading()) {
          unset($tree[$index]);
        }
      }
    }
    return $tree;
  }

}
