<?php

namespace Drupal\masquerade;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceProviderBase;

/**
 * Overrides the menu.link_tree service to point to Masquerade's module one.
 */
class MasqueradeServiceProvider extends ServiceProviderBase {

  /**
   * {@inheritdoc}
   */
  public function alter(ContainerBuilder $container) {
    $definition = $container->getDefinition('menu.link_tree');
    $definition->setClass(MasqueradeMenuLinkTree::class);
  }

}
