<?php

namespace Drupal\masquerade\ProxyClass {

  use Drupal\Core\DependencyInjection\DependencySerializationTrait;
  use Drupal\Core\Menu\MenuLinkTreeInterface;
  use Drupal\Core\Menu\MenuTreeParameters;
  use Symfony\Component\DependencyInjection\ContainerInterface;

  /**
   * Provides a proxy class for \Drupal\masquerade\MasqueradeMenuLinkTree.
   *
   * @see \Drupal\Component\ProxyBuilder
   */
  class MasqueradeMenuLinkTree implements MenuLinkTreeInterface {

    use DependencySerializationTrait;

    /**
     * The id of the original proxied service.
     *
     * @var string
     */
    protected $drupalProxyOriginalServiceId;

    /**
     * The real proxied service, after it was lazy loaded.
     *
     * @var \Drupal\masquerade\MasqueradeMenuLinkTree
     */
    protected $service;

    /**
     * The service container.
     *
     * @var \Symfony\Component\DependencyInjection\ContainerInterface
     */
    protected $container;

    /**
     * Constructs a ProxyClass Drupal proxy object.
     *
     * @param \Symfony\Component\DependencyInjection\ContainerInterface $container
     *   The container.
     * @param string $drupal_proxy_original_service_id
     *   The service ID of the original service.
     */
    public function __construct(ContainerInterface $container, $drupal_proxy_original_service_id) {
      $this->container = $container;
      $this->drupalProxyOriginalServiceId = $drupal_proxy_original_service_id;
    }

    /**
     * {@inheritdoc}
     */
    public function getCurrentRouteMenuTreeParameters($menu_name) {
      return $this->lazyLoadItself()->getCurrentRouteMenuTreeParameters($menu_name);
    }

    /**
     * Lazy loads the real service from the container.
     *
     * @return object
     *   Returns the constructed real service.
     */
    protected function lazyLoadItself() {
      if (!isset($this->service)) {
        $this->service = $this->container->get($this->drupalProxyOriginalServiceId);
      }

      return $this->service;
    }

    /**
     * {@inheritdoc}
     */
    public function load($menu_name, MenuTreeParameters $parameters) {
      return $this->lazyLoadItself()->load($menu_name, $parameters);
    }

    /**
     * {@inheritdoc}
     */
    public function transform(array $tree, array $manipulators) {
      return $this->lazyLoadItself()->transform($tree, $manipulators);
    }

    /**
     * {@inheritdoc}
     */
    public function build(array $tree) {
      return $this->lazyLoadItself()->build($tree);
    }

    /**
     * {@inheritdoc}
     */
    public function maxDepth() {
      return $this->lazyLoadItself()->maxDepth();
    }

    /**
     * {@inheritdoc}
     */
    public function getSubtreeHeight($id) {
      return $this->lazyLoadItself()->getSubtreeHeight($id);
    }

    /**
     * {@inheritdoc}
     */
    public function getExpanded($menu_name, array $parents) {
      return $this->lazyLoadItself()->getExpanded($menu_name, $parents);
    }

  }

}
