<?php

 /**
  * @file
  * Contents of lengthy hook functions
  */

use Drupal\mcapi\Mcapi;

function _mcapi_entity_extra_field_info() {
  //go through all the bundles which are configured to hold wallets
  foreach(Mcapi::walletableBundles() as $entity_type => $bundles) {
    foreach ($bundles as $bundle => $max) {
      $extra[$entity_type] = [
        $bundle => [
          'display' => [
            'wallets_summaries' => [
              'label' => t('Wallets summaries'),
              'description' => t("The 'summary' view of all the entity's wallets."), //' '.l('admin/accounting/wallets/fields', Url::fromUri('admin/accounting/wallets/fields'),
              'weight' => 5,
            ]
          ]
        ]
      ];
    }
  }
  $extra['mcapi_wallet']['mcapi_wallet']['display'] = [];
  $wallet_display = &$extra['mcapi_wallet']['mcapi_wallet']['display'];

  $wallet_display = [
    'stats' => [
      'label' => t('Trading stats'),
      'description' => t('Grid showing trading stats for all currencies'),
      'weight' => 5
    ],
    'balances' => [
      'label' => t('Balance'),
      'description' => t('Small thingy showing balances of all currencies'),
      'weight' => 6
    ],
    'histories' => [
      'label' => t('History chart'),
      'description' => t('One line chart per currency showing balance over time.'),
      'weight' => 7
    ],
    'balance_bars' => [
      'label' => t('Given & received'),
      'description' => t('One barchart per currency showing incoming and outgoing volumes'),
      'weight' => 8
    ],
    'canonical_link' => [
      'label' => t("Link to canonical view"),
      'description' => t("Link to canonical view"),
      'weight' => 11
    ],
    'holder_link' => [
      'label' => t("Link to holder"),
      'description' => t("Each wallet is owned by a content entity"),
      'weight' => 14,
      'visible' => FALSE
    ]
  ];
  $route_provider = \Drupal::service('router.route_provider');
  // Below causes recursion problems
  //we don't want this to break if these views are not present, for any reason
//  if ($route_provider->getRoutesByNames(['view.wallet_transactions.page'])) {
//    $wallet_display['link_transactions'] = [
//      'label' => t("Link to this wallet's transactions"),
//      'description' => t("A page generated by views"),
//      'weight' => 9
//    ];
//  }
//
//  if ($route_provider->getRoutesByNames(['view.income_expenditure.wallet_page'])) {
//    $wallet_display['link_income_expenditure'] = [
//      'label' => t('Link to Income & expenditure'),
//      'description' => t('Two tables showing transactions in either direction'),
//      'weight' => 10
//    ];
//  }
  return $extra;
}


/**
 * Contents of hook_theme().
 */
function _mcapi_theme($existing, $type, $theme, $path) {
  // Which actually this file.
  $file = ['file' => 'mcapi.theme.inc'];
  $items['worths'] = [
    'variables' => [
      'values' => [],
      'separator' => '',
    ],
  ] + $file;
  $items['worth'] = [
    'render element' => 'worth',
  ] + $file;
  $items['mcapi_transaction'] = [
    'render element' => 'transaction',
    'template' => 'transaction',
  ] + $file;
  // The above is the theme wrapper for the below
  // so they both take the same render_element.
  $items['certificate'] = [
    'render element' => 'transaction',
    'template' => 'certificate',
    'pattern' => 'certificate__',
  ] + $file;
  // Experimental.
  $items['mcapi_transaction_twig'] = [
    // When we call this we have to set the $transaction->twig property first.
    'render element' => 'transaction',
    'function' => 'theme_mcapi_transaction_twig',
  ] + $file;
  $items['sentence'] = [
    'render element' => 'transaction',
  ] + $file;
  $items['mcapi_currency'] = [
    'render element' => 'elements',
    'template' => 'currency',
  ] + $file;
  $items['mcapi_timeline'] = [
    'variables' => [
      'title' => '',
      'width' => 0,
      'height' => 0,
      'points' => [],
  // Used for formatting.
      'currency' => NULL,
  // Optional.
      'vaxislabels' => [],
    ],
  ];
  $wallet_callbacks = [
    'mcapi_wallet',
    'mcapi_wallet_component',
    'wallet_balances',
    'wallet_balance_bars',
    'wallet_stats',
  ];
  foreach ($wallet_callbacks as $callback) {
    $items[$callback] = [
      'render element' => 'element',
    ] + $file;
  }

  // This might just be a ul.
  $items['mcapi_extreme_balances'] = [
    'variables' => [
      'largest' => 0,
      'tops' => [],
      'bottoms' => [],
    ],
  ] + $file;
  $items['ordered_wallets'] = [
    'variables' => [
      'id' => '',
      'title' => '',
      'values' => [],
      'width' => 0,
      'height' => 0,
    ],
  ] + $file;
  return $items;
}
