/**
 * @file
 * Behaviours for the Nice Menus module. This uses Superfish 1.4.8.
 *
 * @link http://users.tpg.com.au/j_birch/plugins/superfish
 */

(function ($) {

  'use strict';
  /**
   * Add Superfish to all Nice Menus with some basic options.
   */
  Drupal.behaviors.niceMenus = {
    attach: function (context, settings) {
      $('ul.nice-menu:not(.nice-menus-processed)').addClass('nice-menus-processed').each(function () {
        $(this).superfish({
          // Apply a generic hover class.
          hoverClass: 'over',
          // Disable generation of arrow mark-up.
          autoArrows: false,
          // Disable drop shadows.
          dropShadows: false,
          // Mouse delay.
          delay: drupalSettings.nice_menus_options.delay,
          // Animation speed.
          speed: drupalSettings.nice_menus_options.speed
        });

        $('ul.nice-menu ul').css('display', 'none');
      });
    }
  };

})(jQuery);
