<?php

namespace Drupal\smallads_group\Plugin\GroupContentEnabler;

use Drupal\smallads\Entity\SmallAdType;
use Drupal\Component\Plugin\Derivative\DeriverBase;

class SmalladDeriver extends DeriverBase {

  /**
   * {@inheritdoc}.
   */
  public function getDerivativeDefinitions($base_plugin_definition) {
    foreach (SmallAdType::loadMultiple() as $name => $ad_type) {
      $label = $ad_type->label();
      $this->derivatives[$name] = [
        'entity_bundle' => $name,
        'label' => $label,
        'description' => t('Adds %type content to groups.', ['%type' => $label]),
      ] + $base_plugin_definition;
    }

    return $this->derivatives;
  }

}
