<?php

namespace Drupal\smallads_index;

use Drupal\Core\Routing\RouteSubscriberBase;
use Symfony\Component\Routing\Route;
use Symfony\Component\Routing\RouteCollection;

/**
 * Subscriber for views routes, one for each argument combination.
 *
 * This is necessary for the links and more importantly the autogenerated tasks
 * Seems like a shortcoming in the routing system, but it will certainly do for
 * this module.
 */
class RouteSubscriber extends RouteSubscriberBase {

  /**
   * @var Drupal\smallads\Entity\SmalladType[]
   */
  private $smalladTypes;

  function __construct(\Drupal\Core\Entity\EntityTypeManagerInterface $entity_type_manager) {
    $this->smalladTypes = $entity_type_manager->getStorage('smallad_type')->loadMultiple();
  }

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection) {
    foreach ($this->smalladTypes as $type) {
      $id = $type->id();
      $route = (new Route("/smallads/$id-global"))
        ->setDefaults([
          '_form' => 'Drupal\smallads_index\Form',
          '_title' => 'Global '. $type->label() .' search'
        ])
        ->setRequirement('_permission', 'post smallad');
      //$collection->add('smallads_index.search.' . $id, $route);
    }

  }

}
