<?php

namespace Drupal\smallads_mcapi;

use Drupal\smallads\Entity\SmallAd;

/**
 * Compatibility with mutual_credit package
 */
class FirstWallet {

  /**
   * DefaultValueCallback for wallet field.
   *
   * Get the first wallet of the owner of the given smallad.
   *
   * @param SmallAd $entity
   *
   * @return array
   *   The wallet IDs
   */
  static function get(SmallAd $entity) {
    $uid = $entity->getOwnerId();
    $wids = \Drupal::entityTypeManager()->getStorage('mcapi_wallet')->myWallets($uid);
    //N.B. this NUST be an array
    return $wids;
  }

}
