<?php

namespace Drupal\smallads\EventSubscriber;

use Drupal\migrate\Event\MigratePreRowSaveEvent;
use Drupal\migrate\MigrateSkipRowException;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Modify migrations before saving them.
 *
 * This is necessary for the links and more importantly the autogenerated tasks
 * Seems like a shortcoming in the routing system, but it will certainly do for
 * this module.
 */
class MigrationSubscriber implements EventSubscriberInterface {

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    //Migrate module might not be installed and we can't test for it here because
    //\Drupal::moduleHandler()->moduleExists('migrate_drupal') is not initialised yet!
    //so just replace the constants with their strings defined in Drupal\migrate\Event\MigrateEvents
    return [
      'migrate.pre_row_save' => ['migratePreRowSave']
    ];
  }

  /**
   * Change the field names
   */
  function migratePreRowSave(MigratePreRowSaveEvent $event) {
    $row = $event->getRow();
    $migration = $event->getMigration();
echo "\nDrupal\smallads\EventSubscriber: migratePreRowSave";$migration->id();
    // Change the name of the entity field
    if ($row->getSourceProperty('plugin') == 'd7_smallad') {
      $row->setDestinationProperty(
        'categories',
        $row->getSourceProperty('offers_wants_categories')
      );
      $row->removeDestinationProperty('offers_wants_categories');
    }
    //change the vocab of the terms
    elseif ($migration->id() == 'd7_taxonomy_term:offers_wants_categories') {
      $row->setDestinationProperty('vid', 'categories');
    }
    if($migration->id() == 'd7_comment' and $row->getDestinationProperty('entity_type') == 'smallads') {
      $row->setDestinationProperty('comment_type', 'smallad');
      $row->setDestinationProperty('field_name', 'comments');
      $row->setDestinationProperty('body', $row->getDestinationProperty('comment_body'));// Assumes no comments on transactions
    }

    // Horrible but necessary if we change the entity name
    if ($migration->getDestinationConfiguration()['plugin']) {
      if ($row->getDestinationProperty('bundle') == 'proposition') {
        $row->setDestinationProperty('entity_type', 'smallad');
        $row->setDestinationProperty('bundle', 'mcapi_transaction');
      }
    }

    if ($migration->id() == 'd7_taxonomy_vocabulary:offers_wants_categories') {
        throw new \Drupal\migrate\MigrateSkipRowException();
    }

  }
}
