<?php

namespace Drupal\smallads\EventSubscriber;

use Drupal\Core\Routing\RouteSubscriberBase;
use Symfony\Component\Routing\Route;
use Symfony\Component\Routing\RouteCollection;

/**
 * Subscriber for views routes, one for each argument combination.
 *
 * This is necessary for the links and more importantly the autogenerated tasks
 * Seems like a shortcoming in the routing system, but it will certainly do for
 * this module.
 */
class RouteSubscriber extends RouteSubscriberBase {

  /**
   * @var Drupal\smallads\Entity\SmalladType[]
   */
  private $smalladTypes;

  function __construct(\Drupal\Core\Entity\EntityTypeManagerInterface $entity_type_manager) {
    $this->smalladTypes = $entity_type_manager->getStorage('smallad_type')->loadMultiple();
  }

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection) {
    // @todo reconsider this
    foreach ($this->smalladTypes as $type) {
      $id = $type->id();
      $route = (new Route('/ads/' . $id))
        ->setDefaults([
          '_controller' => 'Drupal\views\Routing\ViewPageController::handle',
          'view_id' => 'smallads_directory',
          'display_id' => 'page_list',
          'arg_0' => $id,
        ])
        ->setRequirement('_permission', 'post smallad');
//      $collection->add('view.ads_by_category.page_list.' . $id, $route);
    }

    //change the title of the canonical entity
    $collection->get('entity.smallad.canonical')
      ->setDefault('_title_callback', '\Drupal\smallads\Controller\SmallAd::canonicalLabel');

  }

}
