<?php

namespace Drupal\smallads\Plugin\QueueWorker;

use Drupal\Core\Queue\QueueWorkerBase;
use Drupal\smallads\Entity\SmallAd;
use Drupal\Core\Link;
use Drupal\Core\Url;

/**
 * Updates a feed's items.
 *
 * @QueueWorker(
 *   id = "smallads_expired_mail",
 *   title = @Translation("Smallad expiry notification"),
 *   cron = {"time" = 60}
 * )
 */
class ExpiredMail extends QueueWorkerBase {

  /**
   * {@inheritdoc}
   *
   * @todo make a settings form and variables for the text of the notifcation mail.
   */
  public function processItem($ad_id) {
    $ad = SmallAd::load($ad_id)->expire();
    $ad->save();
    $owner = $ad->getOwner();

    \Drupal::service('plugin.manager.mail')
      ->mail(
        'smallads',
        'expired',
        $owner->getEmail(),
        $owner->getPreferredLangcode(),
        [
          'smallad' => $ad,
          'user' => $owner
        ]
      );

    \Drupal::logger('smallads')->info(
      'cron expired ad @id and notified !user (@uid) at @mail',
      [
        '@id' => Link::createFromRoute(
          $ad->label(),
          Url::fromRoute('entity.smallad.canonical', ['smallad' => $ad->id()])
        ),
        '%user' => $ad->getOwner()->getDisplayName(),
        '@uid' => $ad->getOwner()->id(),
        '@mail' => $ad->getowner()->getEmail(),
      ]
    );
  }

}
