<?php

namespace Drupal\smallads;

use Drupal\smallads\Entity\SmallAdInterface;
use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Access\AccessResult;

/**
 * Defines an access controller for the SmallAd entity.
 */
class SmallAdAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $smallAd, $operation, AccountInterface $account) {
    if ($account->hasPermission('access administration pages')) {
      return AccessResult::allowed()->cachePerUser()->cachePerPermissions();
    }
    // Owners can do anything with their own content.
    if ($smallAd->getOwnerId() == $account->id()) {
      return AccessResult::allowed()->cachePerUser()->addCacheableDependency($smallAd);
    }
    if ($operation == 'view') {
      switch ($smallAd->scope->value) {
        case SmallAdInterface::SCOPE_PUBLIC:
          return AccessResult::allowed()->addCacheableDependency($smallAd);
        case SmallAdInterface::SCOPE_NETWORK:
          debug('configure smallAds access for REST requests');

        case SmallAdInterface::SCOPE_SITE:
          return AccessResult::allowedIfHasPermission($account, 'access content');
        case SmallAdInterface::SCOPE_GROUP:
          throw new \Exception('If groups are enabled SmallAdAccessControlHandler should be overridden ');
        case SmallAdInterface::SCOPE_PRIVATE:
          return AccessResult::forbidden('Small ad is private')->addCacheableDependency($smallAd);
      }
    }
    return AccessResult::forbidden()->addCacheableDependency($smallAd);
  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL) {
    return AccessResult::allowedIfHasPermission($account, 'post smallad');
  }

}
