<?php

namespace Drupal\cforge\Controller;

use \Drupal\system\Controller\SystemController;

/**
 * Returns a robots.text file.
 */
class Robots extends SystemController {

  /**
   * Page callback.
   *
   * @todo
   * @see https://api.drupal.org/api/drupal/core!includes!bootstrap.inc/function/_drupal_add_http_header/8
   */
  public function page() {
    // I think the Content-type text/plain header will be set automatically.
    if (\Drupal::Config('cforge.settings')->get('robots_protect')) {
      echo 'User-agent: *
      Disallow: /';
    }
    else {
      echo file_get_contents(DRUPAL_ROOT . '/profiles/cforge/robots.txt');
    }
    exit;
  }

}
