<?php

namespace Drupal\cforge;
use \Drupal\node\Entity\Node;

/**
 * Base class to create demo data in any lanaguage.
 */
abstract class DemoUserData {

  public static $firstNames = [];
  public static $lastNames = [];
  public static $names = [];
  public static $streets = [];
  public static $hoods = [];

  /**
   * Get a random neighbourhood.
   */
  public static function randNeighbourhood() {
    static $hoods = [];
    if (empty($hoods)) {
      $nodes = \Drupal::entityTypeManager()
        ->getStorage('node')
        ->loadByProperties(['type' => 'neighbourhood']);
      foreach ($nodes as $node) {
        $hoods[] = $node->getTitle();
      }
    }
    if (empty($hoods)) {
      drupal_set_message('no neighbourhoods created yet');
    }
    return $hoods[array_rand($hoods)];
  }

  /**
   * Get a random street.
   */
  public static function randStreet() {
    $key = array_rand(static::$streets);
    return static::$streets[$key];
  }

  /**
   * Get a random phone number.
   */
  public static function randPhone() {
    return '0' . rand(1000, 9999) . ' ' . rand(100000, 999999);
  }

  /**
   * Create the neighbourhood nodes.
   */
  public static function createNeighbourhoods($hoods = []) {
    if (!$hoods) {
      $hoods = static::$hoods;
    }
    foreach ($hoods as $hood) {
      $exists = \Drupal::entityQuery('node')
        ->condition('type', 'neighbourhood')
        ->condition('title', $hood)
        ->execute();
      if (!$exists) {
        Node::create([
          'type' => 'neighbourhood',
          'title' => trim($hood),
          'uid' => 1,
        ])->save();
      }
    }
  }

  /**
   * Return a randomised firstname and last name.
   */
  public static function getName() {
    static $firstnames, $lastnames = [];
    if (!$firstnames) {
      $firstnames = static::$firstNames;
      shuffle($firstnames);
    }
    if (!$lastnames) {
      $lastnames = static::$lastNames;
      shuffle($lastnames);
    }
    return [array_pop($firstnames), array_pop($lastnames)];
  }

  /**
   * Return the number of demo user names.
   */
  public static function countUsers() {
    return count(static::$firstNames);
  }

}
