<?php

namespace Drupal\cforge;

/**
 * French demo data.
 */
class DemoUserDataFr extends DemoUserData {

  public static $firstNames = ['Alice', 'Bernard', 'Catherine', 'Dominique',
    'Emmanuel', 'Fanny', 'Grégoire', 'Henry', 'Isabelle', 'Jean', 'Kim',
    'Louis', 'Marianne', 'Nancy', 'Olivier', 'Pierre', 'Quentin', 'Renaud',
    'Sylvain', 'Thierry', 'Ursula', 'Véronique', 'William', 'Xavier', 'Yolande',
    'Zoe',
  ];
  public static $lastNames = ['Ansiaux', 'Boulanger', 'Colin', 'Dufour',
    'Enchemin', 'Ferrand', 'Gaillard', 'Humbert', 'Istace', 'Joubert', 'Keeler',
    'Lacroix', 'Marchand', 'Normand', 'Oliver', 'Parmentier', 'Quinet',
    'Rousseau', 'Sauvage', 'Tailleur', 'Ursullan', 'Valenduc', 'Wattiaux',
    'Xhonneux', 'Yernaux', 'Zapatero',
  ];

  public static $streets = [
    'Avenue du Prieuré',
    'Boulevard du Prince',
    'Allée des Noyers',
    'Grand Rue',
    'Chemin des Tanneurs',
    'Parc des Etangs',
    'Rue du Moulin',
    'Route de Belleroche',
    'Impasse des Pinsons',
    'Rue des Panoramas',
  ];

  public static $hoods = [
    'La Roche',
    'Baronville',
    'Moustiers',
    'Templeuve',
    'Aisemont',
  ];

  /**
   * {@inheritdoc}
   */
  public static function vocabs() {
    return [
      'SEL Francais' => [
        '#children' => FALSE,
        'Administration' => [],
        'Alimentation' => [],
        'Artisanat & Bricolage' => [],
        'Arts & Culture' => [],
        'Cours & Langues' => [],
        'Informatique & Eléctro' => [],
        'Maison & Jardin' => [],
        'Mobilité' => [],
        'Santé & Soins' => [],
        'Sports & Evasion' => [],
        'Vêtements plus' => [],
        'Divers' => [],
      ],
      'SEL Belgique, (2 Tier]' => [
        '#children' => TRUE,
        'A Ménage / Entretien maison' => [
          '#children' => FALSE,
          "Nettoyage/ produits d'entretien" => [],
          'Lessive, repassage' => [],
          'Couture, tricot' => [],
          'Rangement' => [],
          'Ménage - Divers' => [],
        ],
        'B Travaux maisons' => [
          '#children' => FALSE,
          'Travaux lourds' => [],
          'Petits travaux divers' => [],
          'Peinture, tapissage, décoration' => [],
          'Electricité' => [],
          'Plomberie, chauffage' => [],
          'Carrelage, plafonnage, maçonnerie' => [],
          'Menuiserie, planchers, meubles' => [],
          "Isolation, économies d'énergie" => [],
          "Travaux - Divers" => [],
        ],
        'C Enfants / Ados' => [
          '#children' => FALSE,
          'Grossesse et bébé' => [],
          'Baby sitting' => [],
          'Stages, animations créatives' => [],
          'Aide scolaire' => [],
          'Jeux et jouets' => [],
          'Enfants - Divers' => [],
        ],
        'D Alimentation / Gastronomie' => [
          '#children' => FALSE,
          'Nettoyage fruits et légumes' => [],
          'Boissons, soupes, sauces' => [],
          'Plats' => [],
          'Desserts' => [],
          "Tables d'hôtes" => [],
          'Cours, conseils, recettes' => [],
          'Alimentation - Divers' => [],
        ],
        'E Santé / Bien-être / Accompagnement' => [
          '#children' => FALSE,
          'Coiffure, esthétique visage et corps' => [],
          'Massage, thérapies, produits naturels' => [],
          'Personnes âgées, malades, immobilisées' => [],
          "Accompagnement, coaching et conseils 'psy'" => [],
          'Santé - Divers' => [],
        ],
        'F Administration / Gestion' => [
          '#children' => FALSE,
          'Classement de papiers, de dossiers' => [],
          'Dactylographie, mise en page' => [],
          'Courriers, démarches administratives' => [],
          'Assurances, questions juridiques' => [],
          'Fiscalité, pension, chômage' => [],
          'Administration - Divers' => [],
        ],
        'G Cours / Formations / Conseils' => [
          '#children' => FALSE,
          'Langues, conversation, traduction' => [],
          'Ecriture, rédaction, orthographe' => [],
          "Recherche d'emploi" => [],
          'Gestion et animation de groupes' => [],
          'Cours - Divers' => [],
        ],
        'H Jardin / Animaux / Nature' => [
          '#children' => FALSE,
          'Jardin : conception, entretien, conseils' => [],
          'Culture potagère, vergers' => [],
          'Récolte de fruits, légumes, plantes' => [],
          "Taille d'arbres et arbustes" => [],
          'Animaux (domestiques -élevage]' => [],
          'Biodiversité, nichoirs, découverte nature' => [],
          'Engrais, semences, plants, produits divers' => [],
          'Jardin et animaux - Divers' => [],
        ],
        'I Arts / Culture / Sports & loisirs' => [
          '#children' => FALSE,
          'Artisanat, peinture, dessin, sculpture' => [],
          'Musique, chant, danse' => [],
          'Photo, vidéo, cinema' => [],
          'Animations, spectacles' => [],
          'Fêtes : conseils, organisation, aide' => [],
          'Promenades, excursions' => [],
          "Jeux (de société, d'extérieur]" => [],
          'Sports' => [],
          'Culture et sport - Divers' => [],
        ],
        'J Transports / Voyages /Hébergement' => [
          '#children' => FALSE,
          'Courses' => [],
          'Covoiturage et transport' => [],
          'Déménagement' => [],
          'Auto-moto-vélo' => [],
          'Voyages, randonnées' => [],
          'Hébergement, échange maisons' => [],
          'Gardiennage maison' => [],
          'Transport - Divers' => [],
        ],
        'K Informatique /Électroménager' => [
          '#children' => FALSE,
          'Dépannage informatique' => [],
          'Réparation électroménager' => [],
          'Formations Internet / email' => [],
          'Formations logiciels' => [],
          'Informatique, électroménager - Divers' => [],
        ],
        'Z Divers (non classées]' => [
          '#children' => FALSE,
        ],
      ],
    ];
  }

}
