<?php

namespace Drupal\cforge\Element;

use Drupal\Core\Form\FormStateInterface;

/**
 * Tweaks the default address form element
 *
 * @FormElement("cforge_address")
 */
class Address extends \Drupal\address\Element\Address {


  /**
   * Override the address widget assuming there is no choice of country and
   * neighbourhood is a dropdown. Restrict the available countries to those in
   * config.
   */
  public static function processAddress(array &$element, FormStateInterface $form_state, array &$complete_form) {
    $element = parent::processAddress($element, $form_state, $complete_form);

    $element['country_code']['#type'] = 'hidden';
    unset($element['country_code']['#options']);
    $element['dependent_locality']['#options'] = cforge_list_neighbourhoods();
    $element['dependent_locality']['#type'] = 'select';
    $element['dependent_locality']['#required'] = TRUE;
    unset($element['dependent_locality']['#size']);

    return $element;
  }


}
