<?php

namespace Drupal\cforge\EventSubscriber;

use Drupal\Core\Routing\RouteSubscriberBase;
use Symfony\Component\Routing\RouteCollection;
use Drupal\Core\Routing\RoutingEvents;

/**
 * Alter routes.
 *
 * Change some routes into admin routes. Change some route titles.
 */
class RouteSubscriber extends RouteSubscriberBase {

  /**
   * {@inheritdoc}
   *
   * Anything the committee does shouldn't be an admin_route.
   */
  protected function alterRoutes(RouteCollection $collection) {
    $route_names = [
      'entity.taxonomy_term.edit_form',
      'entity.taxonomy_term.delete_form',
      'entity.user.edit_form',
    ];
    foreach ($collection as $route_name => &$route) {
      if (in_array($route_name, $route_names)) {
        $route->setOption('_admin_route', FALSE);
      }
    }
    // These routes have new links for committee in the tools menu.
    $collection->get('entity.user.collection')
      ->setDefault('_title', t('Manage @name', ['@name' => t('People')]));
    $collection->get('system.admin_content')
      ->setDefault('_title', t('Manage @name', ['@name' => t('Content')]))
      ->setRequirements(['_permission' => 'access content overview']);

    // Hamlets does not permit the adding of new menus.
    $collection->remove('entity.menu.add_form');

    $collection->get('entity.user.canonical')
      ->setDefault('_title_callback', '\Drupal\cforge\Controller\General::userTitle');

    // For the Commex App, which runs outside of Drupal and hangs after a cache
    // clear becuase it can't find the plugins
    \Drupal::service('validation.constraint')->getDefinitions();
    \Drupal::service('plugin.manager.action')->getDefinitions();
    \Drupal::service('plugin.manager.mail')->getDefinitions();
    \Drupal::service('image.toolkit.manager')->getDefinitions();
    if (\Drupal::moduleHandler()->moduleExists('mcapi')) {
      \Drupal::service('plugin.manager.filter')->getDefinitions();
      \Drupal::service('mcapi.transaction_relative_manager')->getDefinitions();
      \Drupal::service('plugin.manager.entity_reference_selection')->getDefinitions();
      if (\Drupal::moduleHandler()->moduleExists('mcapi_limits')) {
        $defs = \Drupal::service('plugin.manager.mcapi_limits')->getDefinitions();
      }
    }
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    $events[RoutingEvents::ALTER][] = 'onAlterRoutes';
    return $events;
  }

}
