<?php

namespace Drupal\cforge;

use Drupal\Core\Entity\EntityInterface;
use Drupal\smallads\SmallAdAccessControlHandler;
use Drupal\Core\Session\AccountInterface;

/**
 * Defines the access control handler for the smallad entity type.
 *
 * Allows super-neighbours to update Smallads.
 */
class NeighbourhoodSmalladAccess extends SmallAdAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    $result = parent::checkAccess($entity, $operation, $account);
    if ($operation == 'update' && !$result->isAllowed() && $account->hasPermission('edit neighbours')) {
      drupal_set_message('checking Smallad access for neighbourhood');
      if (cforge_same_neighbourhood($entity->getOwner())) {
        $result = $result->allowed()->cachePerUser();
      }
    }
    return $result;
  }

}
