<?php

namespace Drupal\cforge;

use Drupal\Core\Entity\EntityInterface;
use Drupal\user\UserAccessControlHandler;
use Drupal\Core\Session\AccountInterface;

/**
 * Defines the access control handler for the user entity type.
 *
 * Allows super-neighbours to update user profiles.
 *
 * @see \Drupal\user\Entity\User
 */
class NeighbourhoodUserAccess extends UserAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  public function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    $result = parent::checkAccess($entity, $operation, $account);
    if ($operation == 'update' && !$result->isAllowed() && $account->hasPermission('edit neighbours')) {
      drupal_set_message('checking User access for neighbourhood');
      if (cforge_same_neighbourhood($entity)) {
        $result = $result->allowed()->cachePerUser();
      }
    }
    return $result;
  }

}
