<?php

namespace Drupal\cforge;

use Drupal\Core\Entity\EntityInterface;
use Drupal\mcapi\Access\WalletAccessControlHandler;
use Drupal\Core\Session\AccountInterface;

/**
 * Defines the access control handler for the mcapi_wallet entity type.
 *
 * Allows super-neighbours to view and update wallets.
 */
class NeighbourhoodWalletAccess extends WalletAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    $result = parent::checkAccess($entity, $operation, $account);
    if (in_array($operation, ['view', 'update'])) {
      if (!$result->isAllowed() && $account->hasPermission('edit neighbours')) {
        drupal_set_message('checking Wallet access for neighbourhood');
        if (cforge_same_neighbourhood($entity->getOwner())) {
          $result = $result->allowed()->cachePerUser();
        }
      }
    }
    return $result;
  }

}
