<?php

namespace Drupal\cforge\Plugin\DevelGenerate;

use Drupal\mcapi\Entity\Wallet;
use Drupal\devel_generate\Plugin\DevelGenerate\UserDevelGenerate;
use Drupal\user\Entity\User;
use Drupal\field\Entity\FieldConfig;
use Drupal\Core\Form\FormStateInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Base class for generating random users.
 */
abstract class CforgeUserGenerate extends UserDevelGenerate {

  private $configFactory;
  private $accountSwitcher;
  protected $demoDataClass;

  /**
   * Constructor.
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition, $entity_storage, $date_formatter, $config_factory, $account_switcher) {
    parent::__construct($configuration, $plugin_id, $plugin_definition, $entity_storage, $date_formatter);
    $this->configFactory = $config_factory;
    $this->accountSwitcher = $account_switcher;
    module_load_install('cforge');
    $class = cforge_demo_data_class_name();
    $this->demoDataClass = new $class();
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration, $plugin_id, $plugin_definition,
      $container->get('entity.manager')->getStorage('user'),
      $container->get('date.formatter'),
      $container->get('config.factory'),
      $container->get('account_switcher')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function settingsForm(array $form, FormStateInterface $form_state) {
    $form = parent::settingsForm($form, $form_state);
    $form['num']['#value'] = 26;
    $form['num']['#disabled'] = 26;
    unset($form['roles']);
    unset($form['pass']);
    // 1 year ago.
    $form['time_range']['#default_value'] = 31536000;
    $form['time_range']['#type'] = 'hidden';
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  protected function generateElements(array $values) {
    $kill = $values['kill'];
    $pass = $values['pass'];
    $roles = array_filter($values['roles']);
    $countries = FieldConfig::load('user.user.address')->getSetting('available_countries');

    if ($kill) {
      $uids = $this->userStorage->getQuery()
        ->condition('uid', 1, '>')
        ->execute();
      $users = $this->userStorage->loadMultiple($uids);
      $this->userStorage->delete($users);
    }
    if (empty($roles)) {
      $roles = [DRUPAL_AUTHENTICATED_RID];
    }

    // We only have demo data in two languages
    // before saving accounts we need to switch to user 1 otherwise the wallet
    // name will be wrongly derived.
    $this->accountSwitcher->switchTo(User::load(1));
    $count = $this->demoDataClass->countUsers();
    for ($i = 0; $i < $count; $i++) {
      $account = $this->userStorage->create([
        'name' => 'a',
        'pass' => 'demo',
        'mail' => 'temp@example.com',
        'status' => 1,
        'roles' => array_values($roles),
      ]);
      $this->populateFields($account);
      if ($i < 4) {
        $account->addRole(RID_COMMITTEE);
      }
      // 1 user per year.
      $account->address->country_code = reset($countries);
      $this->populateUser($account);
      $account->created->value = REQUEST_TIME - ($i + 1) * 30000000;
      $account->save();
      // And update the created date of the newly created wallet.
      // @todo load the right wallet modify and save it normally!
      $wids = \Drupal::entityQuery('mcapi_wallet')
        ->condition('holder_entity_type', 'user')
        ->condition('holder_entity_id', $account->id())->execute();
      foreach (Wallet::loadMultiple($wids) as $wallet) {
        $wallet->set('created', $account->created->value)->save();
      }
    }
    $this->accountSwitcher->switchBack();
    $this->setMessage(t('@count users created.', ['@count' => $count]));
  }

  /**
   * {@inheritdoc}
   */
  public function populateUser($account) {
    // Populate all fields with sample values.
    $account->phones->value = $this->demoDataClass->randStreet();
    $account->address->address_line1 = $this->demoDataClass->randStreet();
    $account->address->dependent_locality = $this->demoDataClass->randNeighbourhood();
    $phones = [$this->demoDataClass->randPhone(), $this->demoDataClass->randPhone()];
    $account->set('phones', $phones);
  }

}
