<?php

namespace Drupal\cforge\Plugin\migrate\destination;

use Drupal\node\Entity\Node;
use Drupal\migrate\Row;
use Drupal\migrate\Plugin\migrate\destination\EntityContentBase;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\migrate\Plugin\MigrationInterface;

/**
 * Provides entity destination plugin.
 *
 * @MigrateDestination(
 *   id = "cforge_neighbourhoods"
 * )
 */
class Neighbourhoods extends EntityContentBase {

  protected $supportsRollback = FALSE;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition, MigrationInterface $migration = NULL) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $migration,
      $container->get('entity.manager')->getStorage('node'),
      array_keys($container->get('entity.manager')->getBundleInfo('node')),
      $container->get('entity.manager'),
      $container->get('plugin.manager.field.field_type')
    );
  }
  /**
    * {@inheritdoc}
    */
  public function import(Row $row, array $old_destination_id_values = []) {
    $hood_list = $row->getSourceProperty('cforge_neighbourhoods');
    if (empty($hood_list)) {
      drupal_set_message('No Neighbourhoods found to migrate: '.implode('; ', $row->getSource()));
      return [];
    }
    foreach (explode("\n", $hood_list) as $hood) {
      $hood = trim($hood);
      $nodes = $this->storage->loadByProperties(['type' => 'neighbourhood', 'title' => $hood]);
      if ($nodes) {
        $node = reset($nodes);
      }
      else {
        $props = [
          'title' => $hood,
          'type' => 'neighbourhood',
          'status' => TRUE,
          'uid' => 1
        ];
        $node = Node::create($props);
        $node->save();
      }
    }
    //just return the last nid because only one is expecteds
    return [$node->id()];
  }

  /**
   * {@inheritdoc}
   */
  protected function getDefinitionFromEntity($key) {
    /** @var \Drupal\Core\Field\FieldStorageDefinitionInterface[] $definitions */
    $definitions = $this->entityManager->getBaseFieldDefinitions('node');
    $field_definition = $definitions[$key];

    return [
      'type' => $field_definition->getType(),
    ] + $field_definition->getSettings();
  }

}
