<?php

namespace Drupal\cforge;

use Drupal\Core\StringTranslation\TranslationManager as DrupalTranslationManager;
use Drupal\Core\Language\LanguageDefault;

/**
 * Defines a chained translation implementation combining multiple translators.
 */
class TranslationManager extends DrupalTranslationManager {

  private $from;
  private $to;

  /**
   * Constructs a TranslationManager object.
   *
   * @param \Drupal\Core\Language\LanguageDefault $default_language
   *   The default language.
   */
  public function __construct(LanguageDefault $default_language) {
    $this->defaultLangcode = $default_language->get()->getId();
    $terminology = (array) \Drupal::config('cforge.settings')->get('terminology');
    $this->from = array_keys($terminology);
    $this->to = array_values($terminology);
  }

  /**
   * {@inheritdoc}
   */
  public function getStringTranslation($langcode, $string, $context) {
    if ($this->sortedTranslators === NULL) {
      $this->sortedTranslators = $this->sortTranslators();
    }
    foreach ($this->sortedTranslators as $translator) {
      $translation = $translator->getStringTranslation($langcode, $string, $context);
      if ($translation !== FALSE) {
        $string = $translation;
        break;
      }
    }
    return str_replace($this->from, $this->to, $string);
  }

}
