<?php


class links {
// Manages the links of the site, affects access through .htaccess
// Set constants for all hard-coded sections

    var $section_id,
        $page_type,
        $page_id,
        $url,
        $name,
        $body,
        $type,
        $hidden,

        $next_position,
        $complete_url,
        $xhtml,
        $error;

    function links() {

    }
    function page_info($page_type,$page_id) {
        $mysql = new mysql;
        if ($page_type == 1) {
            if ($page_id < 100) {
                $q = 'SELECT url FROM sections WHERE sectionID = 9 LIMIT 1';
            } else {
                $q = 'SELECT url FROM sections WHERE sectionID = 21 LIMIT 1';
            }
            if (!$mysql->result($q)) {
                $this->error = $mysql->error;
                return false;
            }
        } else {
            if (!$mysql->result('SELECT url FROM sections WHERE page_type = '.$page_type.' AND page_id = 0 AND hidden = 0 LIMIT 1')) {
                $this->error = $mysql->error;
                return false;
            }
        }
        $url = $mysql->result['url'].'/';

        if (!$mysql->result('SELECT url,name,body FROM sections WHERE page_type = '.$page_type.' AND page_id = '.$page_id.' LIMIT 1')) {
            $this->error = $mysql->error;
            return false;
        }

        if ($page_id) {
            $url .= $mysql->result['url'].'/';
        }
        $this->url = $url;
        $this->name = $mysql->result['name'];
        if ($mysql->result['body']) {
            $this->body = $GLOBALS['blurb_indent'] . '<div id="page_blurb">'
                              . indent_variable($GLOBALS['blurb_indent'] . ' ', $mysql->result['body'])
                              . $GLOBALS['blurb_indent'] . '</div>';
        }

    }
    function title($page_type,$page_id) {
        $mysql = new mysql;
        if ($mysql->result('SELECT name FROM sections WHERE page_type = '.$page_type.' AND page_id = '.$page_id.' LIMIT 1')) {
            return $mysql->result['name'];
        }

    }
    function rebuild_htaccess() {
        $z = '# Auto-generated by LETS Software '.date('r')."\n";
        $z .= ''."\n";
/* not always supported by apache
        $z .= 'php_value upload_max_filesize 10M'."\n";
        $z .= ''."\n";
        $z .= 'php_flag magic_quotes_gpc off'."\n";
        $z .= ''."\n";
*/
        $z .= 'IndexIgnore .htaccess */.??* *~ *# */HEADER* */README* */_vti*'."\n";
        $z .= ''."\n";
        $z .= '<Limit GET POST>'."\n";
        $z .= 'order deny,allow'."\n";
        $z .= 'deny from all'."\n";
        $z .= 'allow from all'."\n";
        $z .= '</Limit>'."\n";
        $z .= ''."\n";
        $z .= '<Limit PUT DELETE>'."\n";
        $z .= 'order deny,allow'."\n";
        $z .= 'deny from all'."\n";
        $z .= '</Limit>'."\n";
        $z .= ''."\n";
        $z .= '<FilesMatch "\.(inc|tpl|h|ihtml|sql|ini|conf|class|bin|spd|theme|module)$">'."\n";
        $z .= 'deny from all'."\n";
        $z .= '</FilesMatch>'."\n";
        $z .= ''."\n";
        $z .= 'RewriteEngine on'."\n";
        $z .= ''."\n";
        $z .= 'RewriteRule ^index.html$ index.php [L]'."\n";
        $z .= ''."\n";
        // now it gets dynamic
        $mysql = new mysql;
        $mysql->build_array('SELECT sectionID,url FROM sections ORDER BY sectionID');

        $config = new mysql;
        $config->result('SELECT enable_noticeboard,enable_articles,enable_events,enable_links,enable_faq,enable_comments,enable_email,enable_member_list,allow_member_admin_categories,enable_email_contact FROM config LIMIT 1');

        $z .= '# member pages with IDs in the URL'."\n";
        if ($config->result['enable_noticeboard']) { // member noticeboard admin and transaction history
            $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[13]['url'].'/(.*)/$ index.php?page_type=1&page_id=5&noticeboard_id=$1 [L]'."\n";
            $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[11]['url'].'/(.*)/$ index.php?page_type=1&page_id=3&member_id_to_view=$1 [L]'."\n";
        }
        $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[10]['url'].'/(.*)/$ index.php?page_type=1&page_id=2&member_id_to_edit=$1 [L]'."\n";
        if ($config->result['enable_articles']) {
            $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[15]['url'].'/(.*)/$ index.php?page_type=1&page_id=7&article_id=$1 [L]'."\n";
        }
        if ($config->result['enable_events']) {
            $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[16]['url'].'/(.*)/$ index.php?page_type=1&page_id=8&event_id=$1 [L]'."\n";
        }
        if ($config->result['enable_faq']) {
            $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[17]['url'].'/(.*)/$ index.php?page_type=1&page_id=9&faq_id=$1 [L]'."\n";
        }
        if ($config->result['enable_links']) {
            $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[18]['url'].'/(.*)/$ index.php?page_type=1&page_id=10&link_id=$1 [L]'."\n";
        }
        if ($config->result['enable_comments']) {
            $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[19]['url'].'/(.*)/$ index.php?page_type=1&page_id=11&comment_id=$1 [L]'."\n";
        }
        $z .= ''."\n";
        $z .= '# other pages with IDs in the URL'."\n";
        if ($config->result['enable_member_list']) {
            $z .= 'RewriteRule ^'.$mysql->result[5]['url'].'/(.*)/$ index.php?page_type=7&page_id=$1 [L]'."\n";
        }
        if ($config->result['enable_noticeboard']) { // noticeboard entries
            $z .= 'RewriteRule ^'.$mysql->result[0]['url'].'/(.*)/$ index.php?page_type=2&page_id=$1 [L]'."\n";
        }
        if ($config->result['enable_articles']) {
            $z .= 'RewriteRule ^'.$mysql->result[1]['url'].'/(.*)/$ index.php?page_type=3&article_id=$1 [L]'."\n";
        }
        if ($config->result['enable_events']) {
            $z .= 'RewriteRule ^'.$mysql->result[2]['url'].'/(.*)/$ index.php?page_type=4&event_id=$1 [L]'."\n";
        }
        $z .= ''."\n";
        $z .= '# member home'."\n";
        $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'$ index.php?page_type=1 [L]'."\n";
        $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/$ index.php?page_type=1 [L]'."\n";
        $z .= ''."\n";
        $z .= '# standard member pages'."\n";
        $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[9]['url'].'$ index.php?page_type=1&page_id=1 [L]'."\n";
        $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[9]['url'].'/$ index.php?page_type=1&page_id=1 [L]'."\n";
        $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[10]['url'].'$ index.php?page_type=1&page_id=2 [L]'."\n";
        $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[10]['url'].'/$ index.php?page_type=1&page_id=2 [L]'."\n";
        if ($config->result['enable_noticeboard']) { // transaction history, make transaction and noticeboard admin
            $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[11]['url'].'$ index.php?page_type=1&page_id=3 [L]'."\n";
            $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[11]['url'].'/$ index.php?page_type=1&page_id=3 [L]'."\n";
            $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[12]['url'].'$ index.php?page_type=1&page_id=4 [L]'."\n";
            $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[12]['url'].'/$ index.php?page_type=1&page_id=4 [L]'."\n";
            $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[13]['url'].'$ index.php?page_type=1&page_id=5 [L]'."\n";
            $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[13]['url'].'/$ index.php?page_type=1&page_id=5 [L]'."\n";
        }
        $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[14]['url'].'$ index.php?page_type=1&page_id=6 [L]'."\n";
        $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[14]['url'].'/$ index.php?page_type=1&page_id=6 [L]'."\n";
        if ($config->result['enable_articles']) {
            $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[15]['url'].'$ index.php?page_type=1&page_id=7 [L]'."\n";
            $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[15]['url'].'/$ index.php?page_type=1&page_id=7 [L]'."\n";
        }
        if ($config->result['enable_events']) {
            $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[16]['url'].'$ index.php?page_type=1&page_id=8 [L]'."\n";
            $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[16]['url'].'/$ index.php?page_type=1&page_id=8 [L]'."\n";
        }
        if ($config->result['enable_faq']) {
            $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[17]['url'].'$ index.php?page_type=1&page_id=9 [L]'."\n";
            $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[17]['url'].'/$ index.php?page_type=1&page_id=9 [L]'."\n";
        }
        if ($config->result['enable_links']) {
            $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[18]['url'].'$ index.php?page_type=1&page_id=10 [L]'."\n";
            $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[18]['url'].'/$ index.php?page_type=1&page_id=10 [L]'."\n";
        }
        if ($config->result['enable_comments']) {
            $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[19]['url'].'$ index.php?page_type=1&page_id=11 [L]'."\n";
            $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[19]['url'].'/$ index.php?page_type=1&page_id=11 [L]'."\n";
        }
        if ($config->result['allow_member_admin_categories']) {
            $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[31]['url'].'$ index.php?page_type=1&page_id=12 [L]'."\n";
            $z .= 'RewriteRule ^'.$mysql->result[8]['url'].'/'.$mysql->result[31]['url'].'/$ index.php?page_type=1&page_id=12 [L]'."\n";
        }
        $z .= ''."\n";
        $z .= '# standard admin pages'."\n";
        if ($config->result['enable_noticeboard']) { // bulk trading and lets tools
            $z .= 'RewriteRule ^'.$mysql->result[20]['url'].'/'.$mysql->result[21]['url'].'$ index.php?page_type=1&page_id=100 [L]'."\n";
            $z .= 'RewriteRule ^'.$mysql->result[20]['url'].'/'.$mysql->result[21]['url'].'/$ index.php?page_type=1&page_id=100 [L]'."\n";
            $z .= 'RewriteRule ^'.$mysql->result[20]['url'].'/'.$mysql->result[22]['url'].'$ index.php?page_type=1&page_id=101 [L]'."\n";
            $z .= 'RewriteRule ^'.$mysql->result[20]['url'].'/'.$mysql->result[22]['url'].'/$ index.php?page_type=1&page_id=101 [L]'."\n";
        }
        $z .= 'RewriteRule ^'.$mysql->result[20]['url'].'/'.$mysql->result[23]['url'].'$ index.php?page_type=1&page_id=102 [L]'."\n";
        $z .= 'RewriteRule ^'.$mysql->result[20]['url'].'/'.$mysql->result[23]['url'].'/$ index.php?page_type=1&page_id=102 [L]'."\n";
        if ($config->result['enable_noticeboard']) { // lets settings
            $z .= 'RewriteRule ^'.$mysql->result[20]['url'].'/'.$mysql->result[24]['url'].'$ index.php?page_type=1&page_id=103 [L]'."\n";
            $z .= 'RewriteRule ^'.$mysql->result[20]['url'].'/'.$mysql->result[24]['url'].'/$ index.php?page_type=1&page_id=103 [L]'."\n";
        }
        $z .= 'RewriteRule ^'.$mysql->result[20]['url'].'/'.$mysql->result[25]['url'].'$ index.php?page_type=1&page_id=104 [L]'."\n";
        $z .= 'RewriteRule ^'.$mysql->result[20]['url'].'/'.$mysql->result[25]['url'].'/$ index.php?page_type=1&page_id=104 [L]'."\n";
        if ($config->result['enable_articles']) {
            $z .= 'RewriteRule ^'.$mysql->result[20]['url'].'/'.$mysql->result[26]['url'].'$ index.php?page_type=1&page_id=105 [L]'."\n";
            $z .= 'RewriteRule ^'.$mysql->result[20]['url'].'/'.$mysql->result[26]['url'].'/$ index.php?page_type=1&page_id=105 [L]'."\n";
        }
        $z .= 'RewriteRule ^'.$mysql->result[20]['url'].'/'.$mysql->result[27]['url'].'$ index.php?page_type=1&page_id=106 [L]'."\n";
        $z .= 'RewriteRule ^'.$mysql->result[20]['url'].'/'.$mysql->result[27]['url'].'/$ index.php?page_type=1&page_id=106 [L]'."\n";
        if ($config->result['enable_events']) {
            $z .= 'RewriteRule ^'.$mysql->result[20]['url'].'/'.$mysql->result[28]['url'].'$ index.php?page_type=1&page_id=107 [L]'."\n";
            $z .= 'RewriteRule ^'.$mysql->result[20]['url'].'/'.$mysql->result[28]['url'].'/$ index.php?page_type=1&page_id=107 [L]'."\n";
        }
        // log
        $z .= 'RewriteRule ^'.$mysql->result[20]['url'].'/'.$mysql->result[29]['url'].'$ index.php?page_type=1&page_id=108 [L]'."\n";
        $z .= 'RewriteRule ^'.$mysql->result[20]['url'].'/'.$mysql->result[29]['url'].'/$ index.php?page_type=1&page_id=108 [L]'."\n";

        if ($config->result['enable_email']) {
            $z .= 'RewriteRule ^'.$mysql->result[20]['url'].'/'.$mysql->result[30]['url'].'$ index.php?page_type=1&page_id=109 [L]'."\n";
            $z .= 'RewriteRule ^'.$mysql->result[20]['url'].'/'.$mysql->result[30]['url'].'/$ index.php?page_type=1&page_id=109 [L]'."\n";
        }
        $z .= ''."\n";
        $z .= '# main pages'."\n";
        if ($config->result['enable_noticeboard']) {
            $z .= 'RewriteRule ^'.$mysql->result[0]['url'].'$ index.php?page_type=2 [L]'."\n";
            $z .= 'RewriteRule ^'.$mysql->result[0]['url'].'/$ index.php?page_type=2 [L]'."\n";
        }
        if ($config->result['enable_articles']) {
            $z .= 'RewriteRule ^'.$mysql->result[1]['url'].'$ index.php?page_type=3 [L]'."\n";
            $z .= 'RewriteRule ^'.$mysql->result[1]['url'].'/$ index.php?page_type=3 [L]'."\n";
        }
        if ($config->result['enable_events']) {
            $z .= 'RewriteRule ^'.$mysql->result[2]['url'].'$ index.php?page_type=4 [L]'."\n";
            $z .= 'RewriteRule ^'.$mysql->result[2]['url'].'/$ index.php?page_type=4 [L]'."\n";
        }
        if ($config->result['enable_faq']) {
            $z .= 'RewriteRule ^'.$mysql->result[3]['url'].'$ index.php?page_type=5 [L]'."\n";
            $z .= 'RewriteRule ^'.$mysql->result[3]['url'].'/$ index.php?page_type=5 [L]'."\n";
        }
        if ($config->result['enable_links']) {
            $z .= 'RewriteRule ^'.$mysql->result[4]['url'].'$ index.php?page_type=6 [L]'."\n";
            $z .= 'RewriteRule ^'.$mysql->result[4]['url'].'/$ index.php?page_type=6 [L]'."\n";
        }
        if ($config->result['enable_member_list']) {
            $z .= 'RewriteRule ^'.$mysql->result[5]['url'].'$ index.php?page_type=7 [L]'."\n";
            $z .= 'RewriteRule ^'.$mysql->result[5]['url'].'/$ index.php?page_type=7 [L]'."\n";
        }
        // contact
        if ($config->result['enable_email_contact'] and $config->result['enable_email']) {
            $z .= 'RewriteRule ^'.$mysql->result[32]['url'].'/([A-Za-z0-9._%-]*)\+([A-Za-z0-9._%-]*)\+([A-Za-z.]{2,4})$ index.php?page_type=11&n=$1&d=$2&t=$3 [L]'."\n";
            $z .= 'RewriteRule ^'.$mysql->result[32]['url'].'$ index.php?page_type=11 [L]'."\n";
            $z .= 'RewriteRule ^'.$mysql->result[32]['url'].'/$ index.php?page_type=11 [L]'."\n";
        }
        // search
        $z .= 'RewriteRule ^'.$mysql->result[33]['url'].'$ index.php?page_type=12 [L]'."\n";
        $z .= 'RewriteRule ^'.$mysql->result[33]['url'].'/$ index.php?page_type=12 [L]'."\n";
        // lost password
        if ($config->result['enable_email']) {
            $z .= 'RewriteRule ^'.$mysql->result[34]['url'].'$ index.php?page_type=13 [L]'."\n";
            $z .= 'RewriteRule ^'.$mysql->result[34]['url'].'/$ index.php?page_type=13 [L]'."\n";
        }
        // login
        $z .= 'RewriteRule ^'.$mysql->result[35]['url'].'$ index.php?page_type=14 [L]'."\n";
        $z .= 'RewriteRule ^'.$mysql->result[35]['url'].'/$ index.php?page_type=14 [L]'."\n";
        // help
        $z .= 'RewriteRule ^'.$mysql->result[36]['url'].'$ index.php?page_type=15 [L]'."\n";
        $z .= 'RewriteRule ^'.$mysql->result[36]['url'].'/$ index.php?page_type=15 [L]'."\n";
        $extra_pages = new mysql;
        $extra_pages->build_array('SELECT sectionID,url FROM sections WHERE type = 5');
        if (is_array($extra_pages->result)) {
            $z .= ''."\n";
            $z .= '# additional pages'."\n";
            foreach($extra_pages->result as $extra_page) {
                $z .= 'RewriteRule ^'.$extra_page['url'].'/$ index.php?page_type=10&id='.$extra_page['sectionID'].' [L]'."\n";
            }
        }
        $z .= ''."\n";
        $z .= 'RewriteRule ^logout$ index.php?logout=1 [L]'."\n";
        $z .= 'RewriteRule ^logout/$ index.php?logout=1 [L]'."\n";
        $z .= 'RewriteRule ^/$ index.php [L]'."\n";
        $z .= 'RewriteRule ^templates/(.*)$ templates/$1 [L]'."\n";
        $z .= 'RewriteRule ^images/(.*)$ images/$1 [L]'."\n";
        $z .= 'RewriteRule page_not_found/$ index.php?page_type=99 [L]'."\n";
        $z .= 'RewriteRule /(.*) index.php?page_type=99 [L]'."\n";
        $z .= ''."\n";
        $z .= 'ErrorDocument 404 '.URL.'page_not_found/'."\n";

        $handle = fopen(LETS_ROOT.'.htaccess','w');
        if (!$handle) {
            $this->error = 'Could not open file';
            return false;
        }
        if (fwrite($handle,$z) === false) {
            $this->error = 'Could not write to file';
            return false;
        }
        return true;
    }
    function build_url($page_type,$page_id) {
        $mysql = new mysql;
        if ($page_type == 1) {
            if ($page_id < 100) {
                $q = 'SELECT url FROM sections WHERE page_type = '.$page_type.' AND page_id = 0 AND hidden = 0 AND sectionID != 21 LIMIT 1';
            } else {
                $q = 'SELECT url FROM sections WHERE page_type = '.$page_type.' AND page_id = 0 AND hidden = 0 AND sectionID != 9 LIMIT 1';
            }
            if (!$mysql->result($q)) {
                $this->error = $mysql->error;
                return false;
            }
        } else {
            if (!$mysql->result('SELECT url FROM sections WHERE page_type = '.$page_type.' AND page_id = 0 AND hidden = 0 LIMIT 1')) {
                $this->error = $mysql->error;
                return false;
            }
        }
        $url = $mysql->result['url'].'/';
        if ($page_id) {
            if (!$mysql->result('SELECT url FROM sections WHERE page_type = '.$page_type.' AND page_id = '.$page_id.' LIMIT 1')) {
                $this->error = $mysql->error;
                return false;
            }
            $url .= $mysql->result['url'].'/';
        }
        $this->complete_url = $url;
        return true;
    }
    function xhtml() {
        return $this->xhtml;
    }
    function next_position() {
        $mysql = new mysql;
        if ($mysql->result('SELECT max(position) as last_position FROM sections')) {
            $this->next_position = $mysql->result['last_position'] + 1;
        }
    }
    function edit_extra_page() {
        $post_post = remove_slashes($_POST);
        $mysql = new mysql;
        $q = 'UPDATE sections SET '
             . 'name = \''.mysql_real_escape_string($post_post['page_name']).'\', '
             . 'url = \''.$post_post['page_url'].'\', '
             . 'body = \''.mysql_real_escape_string($post_post['page_body']).'\', ';
        if ($post_post['include_in_links']) {
            $q .= 'hidden = 0 ';
        } else {
            $q .= 'hidden = 1 ';
        }
        $q .= ' WHERE sectionID = '.$GLOBALS['page'].' LIMIT 1';

        if ($mysql->query($q)) {
            return true;
        } else {
            $this->error = $mysql->error;
            return false;
        }
    }

    function add_extra_page() {
        $mysql = new mysql;
        $this->next_position();
        $post_post = remove_slashes($_POST);
        $insert = array();

        $insert[0]['name'] = 'page_type';
        $insert[0]['value'] = 10;

        $insert[1]['name'] = 'page_id';
        $insert[1]['value'] = 0;
        $insert[2]['name'] = 'url';
        $insert[2]['value'] = $post_post['page_url'];
        $insert[3]['name'] = 'name';
        $insert[3]['value'] = mysql_real_escape_string($post_post['page_name']);

        $insert[4]['name'] = 'type';
        $insert[4]['value'] = 5;
        $insert[5]['name'] = 'hidden';
        if ($post_post['include_in_links']) {
            $insert[5]['value'] = 0;
        } else {
            $insert[5]['value'] = 1;
        }
        $insert[6]['name'] = 'body';
        $insert[6]['value'] = mysql_real_escape_string($post_post['page_body']);
        $insert[7]['name'] = 'position';
        $insert[7]['value'] = $this->next_position;

        if (!$mysql->insert_values('sections',$insert)) {
            $this->error = $mysql->error;
            return false;
        } else {
            return true;
        }
    }
    function delete_extra_page() {
        if ($GLOBALS['page']) {
            $mysql = new mysql;
            if ($mysql->query('DELETE FROM sections WHERE sectionID = '.$GLOBALS['page'].' LIMIT 1')) {
                return true;
            }
        }
        return false;
    }
    function validate_extra_page() {
        if (!$this->htaccess_writable()) {
            return false;
        }
        if (!$_POST['page_name'] or !$_POST['page_url'] or !$_POST['page_body']) {
            $this->error = 'Field Missing.';
            return false;
        }

        $post_post = remove_slashes($_POST);
        if ((urlencode($post_post['page_url']) != $post_post['page_url']) or strpos(' '.$post_post['page_url'],'/')) {
            $this->error = 'URL contains disallowed characters';
            return false;
        }
        if ($GLOBALS['page']) {
            $q = "SELECT sectionID FROM sections WHERE url = '".$post_post['page_url']."' AND sectionID != ".$GLOBALS['page'].' LIMIT 1';
        } else {
            $q = "SELECT sectionID FROM sections WHERE url = '".$post_post['page_url'].'\' LIMIT 1';
        }
        $mysql = new mysql;
        $mysql->num_rows($q);
        if ($mysql->num_rows) {
            $this->error = 'URL exists on another page. No duplicates possible.';
            return false;
        }
        if (VALIDATE_XHTML) {
            $xhtml_report = valid_XHTML($post_post['page_body']);
            $xhtml_report .= valid_XHTML($post_post['page_name']);
            if ($xhtml_report) {
                $this->error = $xhtml_report;
                return false;
            }
        }
        return true;
    }
    function extra_pages_html($i,$url,$type,$id = 0) {
        if (!$this->htaccess_writable()) {
            $z .= "<h2>Cannot Add Aditional Pages</h2>";
            $z .= " Ensure the file: ".PATH.".htaccess exists and is writable.<br />";
            return $z;
        }
        $include_in_links = 1;
        $mysql = new mysql;

        $z = '<!-- extra_pages_form -->'
             . '<div class="extra_pages_form">';
        // look for existing pages
        $mysql->build_array('SELECT sectionID,name FROM sections WHERE type = 5');
        if (is_array($mysql->result)) {
            $z .= " <h2>Current Additional Pages</h2>";
            foreach($mysql->result as $page) {
                $z .= ' <a href="'.URL.$url.'?page='.$page['sectionID'].append_url(' ?').'">'.$page['name']."</a><br />";
            }
        }
        if ($type == 'edit' and $id) {
            $mysql->result('SELECT * FROM sections WHERE sectionID = '.$id.' LIMIT 1');
            if (!is_array($mysql->result)) {
                $this->error = $mysql->error;
            }
            if ($mysql->result['hidden']) {
                $include_in_links = 0;
            }
        }

        if ($type == 'add') {
            $z .= " <h2>Add an Additional Page</h2>\n";
        } elseif ($type == 'edit' and $id) {
            $z .= " <h2>Edit Page \"".$mysql->result['name']."\" or <a href=\"".URL.$url.append_url(0)."\">Add an Additional Page</a></h2>\n";
        }
        if (isset($mysql->result['name'])) $name = $mysql->result['name']; else $name = '';
        if (isset($mysql->result['url'])) $form_url = $mysql->result['url']; else $form_url = '';
        if (isset($mysql->result['body'])) $body = $mysql->result['body']; else $body = '';
        $z .= ' All fields are required. The URL must be unique.<br /><br />';
        $z .= ' <fieldset>';
        $z .= ' <form name="extra_page" method="POST" action="' . URL . $url . append_url() . '">';
        $z .= '  <label for="page_name">Page Name</label>';
        $z .= '  <input type="text" id="page_name" name="page_name" maxlength="255" value="' . $name . '" /><br class="left" />'."";
        $z .= '  <label for="include_in_links">Show in global links?</label>';
        $z .= '  <input type="checkbox" id="include_in_links" name="include_in_links" value="1"' . set_checked($include_in_links) . ' /><br class="left" />';
        $z .= '  <label for="page_url">URL</label>';
        $z .= '  <input type="text" id="page_url" name="page_url" maxlength="255" value="' . $form_url .'" /><br class="left" />';
        $z .= '  <label for="page_body">Body</label>';
        $z .= '  <textarea id="page_body" name="page_body" cols=\"80\" rows=\"6\">' . htmlspecialchars($body) . "</textarea><br class=\"left\" />";

        if ($type == 'edit' and $id) {
            $z .= '  <input type="hidden" name="page" value="' . $id . '" />';
            $z .= '  <input class="page_button" type="submit" name="submit" value="Edit Page" /><br /><br /><input class="page_button" type="submit" name="submit" value="Delete Page" />';
        } else {
            $z .= '  <input class="page_button" type="submit" name="submit" value="Add Page" />';
        }

        $z .= "</form>";
        $z .= "</fieldset>";
        $z .= '<!-- /extra_pages -->';
        return $z;

    }
    function move_link($id_to_move,$id_to_replace) {
        $mysql = new mysql;
        $current_pos = 0;
        $new_pos = 0;
        if ($mysql->result('SELECT position FROM sections WHERE sectionID = '.$id_to_move.' LIMIT 1')) {
            $current_pos = $mysql->result['position'];
        }
        if ($mysql->result('SELECT position FROM sections WHERE sectionID = '.$id_to_replace.' LIMIT 1')) {
            $new_pos = $mysql->result['position'];
        }
        if (!$current_pos or !$new_pos) {
            $this->error = $mysql->error;
            return false;
        }
        if (!$mysql->query('UPDATE sections SET position = '.$new_pos.' WHERE sectionID = '.$id_to_move.' LIMIT 1')) {
            return false;
        }
        if (!$mysql->query('UPDATE sections SET position = '.$current_pos.' WHERE sectionID = '.$id_to_replace.' LIMIT 1')) {
            return false;
        }
        return true;
    }
    function up_down_link($id,$position,$type,$url) {
        $mysql = new mysql;
        $down_id = 0;
        $up_id = 0;

        if ($type == 1 or $type == 5) {
            if ($mysql->result('SELECT sectionID FROM sections WHERE position > '.$position.' AND (type = 1 OR type = 5) AND hidden = 0 AND (sectionID != 9 AND sectionID != 21) ORDER BY position ASC LIMIT 1')) {
                $down_id = $mysql->result['sectionID'];
            }
            if ($mysql->result('SELECT sectionID FROM sections WHERE position < '.$position.' AND (type = 1 OR type = 5) AND hidden = 0 AND (sectionID != 9 AND sectionID != 21) ORDER BY position DESC LIMIT 1')) {
                $up_id = $mysql->result['sectionID'];
            }
        } else {
            if ($mysql->result('SELECT sectionID FROM sections WHERE position > '.$position.' AND type = '.$type.' AND hidden = 0 AND (sectionID != 9 AND sectionID != 21) ORDER BY position ASC LIMIT 1')) {
                $down_id = $mysql->result['sectionID'];
            }
            if ($mysql->result('SELECT sectionID FROM sections WHERE position < '.$position.' AND type = '.$type.' AND hidden = 0 AND (sectionID != 9 AND sectionID != 21) ORDER BY position DESC LIMIT 1')) {
                $up_id = $mysql->result['sectionID'];
            }
        }

        if (!$down_id and !$up_id) {
            return '';
        }

        if ($down_id and $up_id) {
            return ' (<span class="up_down">Move <a href="'.URL.$url.'?link_id='.$id.'&replace_id='.$up_id.append_url(' ?').'">Up</a> or <a href="'.URL.$url.'?link_id='.$id.'&replace_id='.$down_id.append_url(' ?').'">Down</a>)</span>';
        }
        if ($down_id) {
            return ' (<span class="up_down">Move <a href="'.URL.$url.'?link_id='.$id.'&replace_id='.$down_id.append_url(' ?').'">Down</a>)</span>';
        }
        if ($up_id) {
            return ' (<span class="up_down">Move <a href="'.URL.$url.'?link_id='.$id.'&replace_id='.$up_id.append_url(' ?').'">Up</a>)</span>';
        }
    }
    function htaccess_writable() {
        if (file_exists(PATH.'.htaccess')) {
            if(!is_writable(PATH.'.htaccess')) {
                if (chmod(PATH.'.htaccess',0777)) {
                    if(is_writable(PATH.'.htaccess')) {
                        return true;
                    }
                }
                return false;
            } else {
                return true;
            }
        } else {
            return false;
        }
    }
    function update_structure() {
        $mysql = new mysql;
        $errors = '';

        $post_post = remove_slashes($_POST);
        $mysql->build_array('SELECT * FROM sections WHERE (type = 1 AND hidden = 0) OR (sectionID = 9 OR sectionID = 21)');
        if (is_array($mysql->result)) {
            foreach($mysql->result as $link) {
                if (!$post_post['name'][$link['sectionID']] or !$post_post['url'][$link['sectionID']] or !$post_post['plural'][$link['sectionID']] or !$post_post['singular'][$link['sectionID']]) {
                    $errors .= 'Missing Field in Global Links<br />';
                }
                if (urlencode($post_post['url'][$link['sectionID']]) != $post_post['url'][$link['sectionID']]) {
                    $errors .= 'Error in URL:'.$post_post['url'][$link['sectionID']].'<br />';
                }
            }
        }
        $mysql->build_array('SELECT * FROM sections WHERE (type = 2 OR type = 3) AND hidden = 0');
        if (is_array($mysql->result)) {
            foreach($mysql->result as $link) {
                if (!$post_post['name'][$link['sectionID']] or !$post_post['url'][$link['sectionID']]) {
                    $errors .= 'Missing Field in '.ucwords(MEMBERS_NAME_SINGULAR).'/'.ucwords(ADMIN_NAME_SINGULAR).' Links<br />';
                }
                if ((urlencode($post_post['url'][$link['sectionID']]) != $post_post['url'][$link['sectionID']]) or strpos(' '.$post_post['url'],'/')) {
                    $errors .= 'Error in URL:'.$post_post['url'][$link['sectionID']].'<br />';
                }
            }
        }

        $secondary_mysql = new mysql;
        $dup_array = array();
        for($j=0;$j<35;$j++) {
            if (!isset($post_post['url'][$j])) $post_post['url'][$j] = '';
            if ($post_post['url'][$j]) {
                $secondary_mysql->result('SELECT type FROM sections WHERE sectionID = '.$j.' LIMIT 1');
                if (count($dup_array) > 0) {
                    foreach($dup_array as $dup_url) {
                        if ($dup_url['url'] == $post_post['url'][$j] and $dup_url['type'] == $secondary_mysql->result['type']) {
                            $errors .= 'Duplicate URL found: '.$dup_url['url'].'<br />';
                        }
                    }
                }
                $dup_array[$j]['url'] = $post_post['url'][$j];
                $dup_array[$j]['type'] = $secondary_mysql->result['type'];
            }
        }

        if ($errors) {
            $this->error = $errors;
            return false;
        }
        $mysql->build_array('SELECT * FROM sections');
        if (is_array($mysql->result)) {
            foreach($mysql->result as $link) {
                if (isset($post_post['name'][$link['sectionID']])) {
                    if (!isset($post_post['singular'][$link['sectionID']])) $post_post['singular'][$link['sectionID']] = '';
                    if (!isset($post_post['plural'][$link['sectionID']])) $post_post['plural'][$link['sectionID']] = '';
                    if ($post_post['name'][$link['sectionID']]) {
                        if (!$mysql->query("UPDATE sections SET name = '".addslashes($post_post['name'][$link['sectionID']])."', url = '".$post_post['url'][$link['sectionID']]."', plural = '".addslashes($post_post['plural'][$link['sectionID']])."', singular = '".addslashes($post_post['singular'][$link['sectionID']])."', body = '".addslashes($post_post['body'][$link['sectionID']])."' WHERE sectionID = ".$link['sectionID'].' LIMIT 1')) {
                            $errors = 'Had problems updating database';
                        }
                    }
                }
            }
        }
        if ($errors) {
            $this->error = $errors;
            return false;
        }
        return true;

    }
    function positioning_html($i,$url) {
        $mysql = new mysql;
        $z = "<!-- link_positioning_html -->";
        $z .= "<div id=\"site_structure_html\">";
        $z .= " <h2>Positioning</h2>";
        $z .= " <strong>Note:</strong> Links: Contact, Search, Login, Help and Lost Password can be shown or hidden in Settings.<br />";
        // site links
        $z .= " <strong>Global Links:</strong><br />";
        $mysql->build_array('SELECT name,sectionID,type,position FROM sections WHERE (type = 1 OR type = 5) AND hidden = 0 ORDER BY position ASC');
        if (is_array($mysql->result)) {
            foreach($mysql->result as $link) {
                $z .= ' '.$link['name'].$this->up_down_link($link['sectionID'],$link['position'],$link['type'],$url).'<br />'."";
            }
        } else {
            // doc error
        }
        // member links
        $z .= " <br />";
        $z .= " <strong>".ucwords(MEMBERS_NAME_SINGULAR)." Links:</strong><br />";
        $mysql->build_array('SELECT name,sectionID,type,position FROM sections WHERE type = 2 AND hidden = 0 AND sectionID != 9 ORDER BY position ASC');
        if (is_array($mysql->result)) {
            foreach($mysql->result as $link) {
                $z .= ' '.$link['name'].$this->up_down_link($link['sectionID'],$link['position'],$link['type'],$url).'<br />'."";
            }
        } else {
            // doc error
        }
        // admin links
        $z .= " <br />";
        $z .= " <strong>".ucwords(ADMIN_NAME_SINGULAR)." Links:</strong><br />";
        $mysql->build_array('SELECT name,sectionID,type,position FROM sections WHERE type = 3 AND hidden = 0 AND sectionID != 21 ORDER BY position ASC');
        if (is_array($mysql->result)) {
            foreach($mysql->result as $link) {
                $z .= ' '.$link['name'].$this->up_down_link($link['sectionID'],$link['position'],$link['type'],$url).'<br />'."";
            }
        } else {
            // doc error
        }
        $z .= "</div>";
        $z .= "<!-- /link_positioning_html -->";
        return $z;

    }
    function admin_html($i,$url) {
        if (!$this->htaccess_writable()) {
            $z .= " <h2>Further Options disabled</h2>";
            $z .= " Ensure the file: ".PATH.".htaccess exists and is writable.<br />";
            return $z;
        }

        $mysql = new mysql;
        $z = "<!-- site_structure_html -->";
        $z .= "<div id=\"site_structure_html\">";

        $z .= " <h2>Structure</h2>";
        $z .= " <strong>Warning:</strong> Changing the URLs of a website should only be done in the initial configuration. People with bookmarks to old URLs will get a \"Page Not Found\".<br /><br />";
        $z .= " <strong>Notes:</strong> URLs must be unique to their respected groups which are Global, Member and Admin. If Member and Admin URLs are the same they become the same group and uniqueness must be adhered to with their child URLs.<br /><br />";
        $z .= " <strong>Display Name:</strong> This field is displayed as-is in the navigation links, on page headings and page titles.<br />";
        $z .= " <strong>URL:</strong> Because this field actually becomes part of the url is must not contain spaces or special characters<br />";
        $z .= " <strong>Singular and Plural Names:</strong> These fields are used throughout the website. Case is adjusted depending on where they appear. If, for example, \"Noticeboard Entries\" was replaced with \"Listings\", search results would be displayed as \"X listings found\".<br />";
        $z .= " <strong>Blurb:</strong> These fields are displayed in prominent positions on their respected pages if used.<br /><br />";
        if (!ENABLE_NOTICEBOARD or !ENABLE_ARTICLES or !ENABLE_EVENTS or !ENABLE_FAQ or !ENABLE_LINKS or !ENABLE_MEMBER_LIST) {
            $z .= " The following sections are currently inactive. Enable then in settings.";
            if (!ENABLE_NOTICEBOARD) $z .= ' <strong>'.NOTICEBOARD_NAME.'</strong><br />'."";
            if (!ENABLE_ARTICLES) $z .= ' <strong>'.ARTICLES_NAME.'</strong><br />'."";
            if (!ENABLE_EVENTS) $z .= ' <strong>'.EVENTS_NAME.'</strong><br />'."";
            if (!ENABLE_FAQ) $z .= ' <strong>'.FAQ_NAME.'</strong><br />'."";
            if (!ENABLE_LINKS) $z .= ' <strong>'.LINKS_NAME.'</strong><br />'."";
            if (!ENABLE_MEMBER_LIST) $z .= ' <strong>'.MEMBER_LIST_NAME.'</strong><br />'."";
        }

        $z .= ' <form name="site_structure" method="post" action="'.URL.$url.append_url($url).'">'."";
        $z .= "  <table>";
        $z .= "   <tr>";
        $z .= "    <th class=\"h\">Hard Coded As</th>";
        $z .= "    <th class=\"h\">Type</th>";
        $z .= "    <th class=\"h\">Display Name</th>";
        $z .= "    <th class=\"h\">URL</th>";
        $z .= "    <th class=\"h\">Singular Name</th>";
        $z .= "    <th class=\"h\">Plural Name</th>";
        $z .= "    <th class=\"h\">Blurb</th>";
        $z .= "    <th class=\"h\">Notes</th>";
        $z .= "   </tr>";

        // global links
        $mysql->build_array('SELECT * FROM sections WHERE type = 1 AND hidden = 0 ORDER BY position ASC');
        if (is_array($mysql->result)) {
            foreach($mysql->result as $link) {
                $z .= '<tr>';
                switch ($link['page_type']) {
                    case 2: $z .= '<td>Noticeboard</td>'; break;
                    case 3: $z .= '<td>Articles</td>'; break;
                    case 4: $z .= '<td>Events</td>'; break;
                    case 5: $z .= '<td>FAQ</td>'; break;
                    case 6: $z .= '<td>Links</td>'; break;
                    case 7: $z .= '<td>Member List</td>'; break;
                    case 11: $z .= '<td>Contact</td>'; break;
                    case 12: $z .= '<td>Search</td>'; break;
                    case 13: $z .= '<td>Lost Password</td>'; break;
                    case 14: $z .= '<td>Login</td>'; break;
                    case 15: $z .= '<td>Help</td>'; break;
                }
                $z .= '<td>Global Link</td>';
                $z .= '<td>';
                $z .= '<input type="text" name="name['.$link['sectionID'].']" value="'.htmlspecialchars($link['name']).'" /></td>';
                $z .= '<td>';
                $z .= '<input type="text" name="url['.$link['sectionID'].']" value="'.$link['url'].'" /></td>';
                $z .= '<td>';
                $z .= '<input type="text" name="singular['.$link['sectionID'].']" value="'.htmlspecialchars($link['singular']).'" /></td>';
                $z .= '<td>';
                $z .= '<input type="text" name="plural['.$link['sectionID'].']" value="'.htmlspecialchars($link['plural']).'" /></td>';
                $z .= '<td>';
                $z .= '<textarea class="body" name="body['.$link['sectionID'].']" />'.htmlspecialchars($link['body']).'</textarea></td>';
                $z .= '<td>&nbsp;</td>';
            }
        } else {
            // doc error
        }
        // member and admin
        $mysql->build_array('SELECT * FROM sections WHERE sectionID = 9 OR sectionID = 21');
        if (is_array($mysql->result)) {
            foreach($mysql->result as $link) {
                $z .= '<tr>';
                if ($link['sectionID'] == 9) {
                    $z .= '<td>Member</td>';
                } else {
                    $z .= '<td>Admin</td>';
                }
                $z .= '<td>Global Setting</td>';
                $z .= '<td>';
                $z .= '<input type="text" name="name[' . $link['sectionID'] . ']" value="' . htmlspecialchars($link['name']) . '" /></td>';
                $z .= '<td>';
                $z .= '<input type="text" name="url[' . $link['sectionID'] . ']" value="' . $link['url'] . '" /></td>';
                $z .= '<td>';
                $z .= '<input type="text" name="singular[' . $link['sectionID'] . ']" value="' . htmlspecialchars($link['singular']) . '" /></td>';
                $z .= '<td>';
                $z .= '<input type="text" name="plural[' . $link['sectionID'] . ']" value="' . htmlspecialchars($link['plural']) . '" /></td>';
                $z .= '<td>';
                $z .= '<textarea class="body" name="body[' . $link['sectionID'] . ']" />' . htmlspecialchars($link['body']) . '</textarea></td>';
                $z .= '<td>&nbsp;</td>';
            }
        } else {
            // doc error
        }
        // member links
        $mysql->build_array('SELECT * FROM sections WHERE type = 2 AND hidden = 0 AND page_id > 0 ORDER BY position ASC');
        if (is_array($mysql->result)) {
            foreach($mysql->result as $link) {
                $z .= '<tr>';
                if ($link['page_id'] == 2) {
                    $z .= '<td>Edit Account</td>';
                } elseif ($link['page_id'] == 3) {
                    $z .= '<td>Transaction History</td>';
                } elseif ($link['page_id'] == 4) {
                    $z .= '<td>Make a Transaction</td>';
                } elseif ($link['page_id'] == 5) {
                    $z .= "   <td>Noticeboard Admin</td>";
                } elseif ($link['page_id'] == 6) {
                    $z .= '<td>Edit Colours</td>';
                } elseif ($link['page_id'] == 7) {
                    $z .= '<td>Articles Admin</td>';
                } elseif ($link['page_id'] == 8) {
                    $z .= '<td>Events Admin</td>';
                } elseif ($link['page_id'] == 9) {
                    $z .= '<td>FAQ Admin</td>';
                } elseif ($link['page_id'] == 10) {
                    $z .= '<td>Links Admin</td>';
                } elseif ($link['page_id'] == 12) {
                    $z .= '<td>Edit Categories</td>';
                }
                $z .= '<td>Member Link</td>';
                $z .= '<td>';
                $z .= '<input type="text" name="name[' . $link['sectionID'] . ']" value="' . htmlspecialchars($link['name']) . '" /></td>';
                $z .= '<td>';
                $z .= '<input type="text" name="url[' . $link['sectionID'] . ']" value="' . $link['url'] . '" /></td>';
                $z .= '<td>&nbsp;</td>';
                $z .= '<td>&nbsp;</td>';
                $z .= '<td>';
                $z .= '<textarea class="body" name="body[' . $link['sectionID'] . ']" />' . htmlspecialchars($link['body']) . '</textarea></td>';
                $z .= '<td>&nbsp;</td>';
            }
        } else {
            // doc error
        }
        // admin links
        $mysql->build_array('SELECT * FROM sections WHERE type = 3 AND hidden = 0 AND page_id > 0 ORDER BY position ASC');
        if (is_array($mysql->result)) {
            foreach($mysql->result as $link) {
                $z .= "   <tr>";
                if ($link['page_id'] == 100) {
                    $z .= "<td>Bulk Trading</td>";

                } elseif ($link['page_id'] == 101) {
                    $z .= "<td>LETS Tools</td>";
                } elseif ($link['page_id'] == 102) {
                    $z .= "<td>Form Settings</td>";
                } elseif ($link['page_id'] == 103) {
                    $z .= "<td>LETS Settings</td>";
                } elseif ($link['page_id'] == 104) {
                    $z .= "<td>Site Structure</td>";
                } elseif ($link['page_id'] == 105) {
                    $z .= "<td>Validate Articles</td>";
                } elseif ($link['page_id'] == 106) {
                    $z .= "<td>Site Settings</td>";
                } elseif ($link['page_id'] == 107) {
                    $z .= "<td>Validate Events</td>";
                } elseif ($link['page_id'] == 109) {
                    $z .= "<td>Send Email</td>";
                }
                $z .= "<td>Admin Link</td>";
                $z .= "<td>";
                $z .= '<input type="text" name="name['.$link['sectionID'].']" value="'.htmlspecialchars($link['name']).'" /></td>'."";
                $z .= "<td>";
                $z .= '<input type="text" name="url['.$link['sectionID'].']" value="'.$link['url'].'" /></td>'."";
                $z .= "<td>&nbsp;</td>";
                $z .= "<td>&nbsp;</td>";
                $z .= '<td>';
                $z .= '<textarea class="body" name="body['.$link['sectionID'].']" />'.htmlspecialchars($link['body']).'</textarea></td>'."";
                $z .= "<td>&nbsp;</td>";
            }
        } else {
            // doc error
        }

        $z .= "  </table><br /><br />";
        $z .= '  <input class="reverse_transaction_button" type="submit" name="submit" value="Submit" /><br class="left" />'."";
        $z .= " </form>";
        $z .= "</div>";
        $z .= "<!-- site_structure_html -->";
        return $z;

    }

    function initialize($i) {
        $mysql = new mysql('html');

        // site links
        if (!$mysql->build_array('SELECT * FROM sections ORDER BY position ASC')) {
            $this->error = $mysql->error;
            return false;
        }
        $z = '<!-- nav_links -->';
        $z .= '<div id="nav_bar">';
        $z .= '<span class="nav_links_heading">Site Menu:</span><br /><br />';
        $z .= '<ul>';
        if (!isset($_GET['page_type'])) {
            $z .= " <li><a class=\"nav_link_selected\" href=\"".URL.append_url(0)."\">Home</a></li>";
        } else {
            $z .= " <li><a class=\"nav_link\" href=\"".URL.append_url(0)."\">Home</a></li>";
        }
        foreach ($mysql->result as $link) {
            $selected = '';
            if (isset($_GET['page_type'])) {
                if ($_GET['page_type'] == $link['page_type']) {
                    if (!$link['page_id'] and $link['page_type'] != 10) {
                        $selected = '_selected';
                    } elseif ($link['page_type'] == 10) {
                        if ($link['sectionID'] == $_GET['id']) {
                            $selected = '_selected';
                        }
                    } else {
                        if (isset($_GET['page_id']) and isset($link['page_id'])) {
                            if ($_GET['page_id'] == $link['page_id']) {
                                $selected = '_selected';
                            }
                        }
                    }
                }
            }

            // define urls for use elsewhere
            if ($link['type'] == 2 and $link['page_type'] == 1 and !$link['page_id']) {
                define("MEMBERS_URL",                             $link['url']);
                define("MEMBERS_NAME",                          $link['name']);
                define("MEMBERS_NAME_PLURAL",            $link['plural']);
                define("MEMBERS_NAME_SINGULAR",        $link['singular']);
            }
            if ($link['type'] == 3 and $link['page_type'] == 1 and !$link['page_id']) {
                define("ADMIN_URL",                                  $link['url']);
                define("ADMIN_NAME",                               $link['name']);
                define("ADMIN_NAME_PLURAL",                 $link['plural']);
                define("ADMIN_NAME_SINGULAR",             $link['singular']);
            }
            if ($link['type'] == 1 and $link['page_type'] == 2 and !$link['page_id'] and ENABLE_NOTICEBOARD) {
                $z .= ' <li><a class="nav_link'.$selected.'" href="'.URL.$link['url'].'/'.append_url(0).'">'.$link['name']."</a></li>";
                define("NOTICEBOARD_URL",                       $link['url']);
                define("NOTICEBOARD_NAME",                    $link['name']);
                define("NOTICEBOARD_NAME_PLURAL",      $link['plural']);
                define("NOTICEBOARD_NAME_SINGULAR",  $link['singular']);

            }
            if ($link['type'] == 1 and $link['page_type'] == 3 and !$link['page_id'] and ENABLE_ARTICLES) {
                $z .= ' <li><a class="nav_link'.$selected.'" href="'.URL.$link['url'].'/'.append_url(0).'">'.$link['name']."</a></li>";
                define("ARTICLES_URL",                              $link['url']);
                define("ARTICLES_NAME",                          $link['name']);
                define("ARTICLES_NAME_PLURAL",            $link['plural']);
                define("ARTICLES_NAME_SINGULAR",        $link['singular']);
            }
            if ($link['type'] == 1 and $link['page_type'] == 4 and !$link['page_id'] and ENABLE_EVENTS) {
                $z .= ' <li><a class="nav_link'.$selected.'" href="'.URL.$link['url'].'/'.append_url(0).'">'.$link['name']."</a></li>";
                define("EVENTS_URL",                                $link['url']);
                define("EVENTS_NAME",                             $link['name']);
                define("EVENTS_NAME_PLURAL",               $link['plural']);
                define("EVENTS_NAME_SINGULAR",           $link['singular']);
            }
            if ($link['type'] == 1 and $link['page_type'] == 5 and !$link['page_id'] and ENABLE_FAQ) {
                $z .= ' <li><a class="nav_link'.$selected.'" href="'.URL.$link['url'].'/'.append_url(0).'">'.$link['name']."</a></li>";
                define("FAQ_URL",                                       $link['url']);
                define("FAQ_NAME",                                   $link['name']);
                define("FAQ_NAME_PLURAL",                     $link['plural']);
                define("FAQ_NAME_SINGULAR",                 $link['singular']);
            }
            if ($link['type'] == 1 and $link['page_type'] == 6 and !$link['page_id'] and ENABLE_LINKS) {
                $z .= ' <li><a class="nav_link'.$selected.'" href="'.URL.$link['url'].'/'.append_url(0).'">'.$link['name']."</a></li>";
                define("LINKS_URL",                                   $link['url']);
                define("LINKS_NAME",                                $link['name']);
                define("LINKS_NAME_PLURAL",                  $link['plural']);
                define("LINKS_NAME_SINGULAR",              $link['singular']);
            }
            if ($link['type'] == 1 and $link['page_type'] == 7 and !$link['page_id'] and ENABLE_MEMBER_LIST) {
                $z .= ' <li><a class="nav_link'.$selected.'" href="'.URL.$link['url'].'/'.append_url(0).'">'.$link['name']."</a></li>";
                define("MEMBER_LIST_URL",                     $link['url']);
                define("MEMBER_LIST_NAME",                  $link['name']);
            }

            if ($link['type'] == 5 and $link['page_type'] == 10 and !$link['hidden'] or
                ($link['page_type'] == 11 and (ENABLE_EMAIL and ENABLE_EMAIL_CONTACT)) or
                ($link['page_type'] == 12 and SHOW_SEARCH_LINK) or
                ($link['page_type'] == 14 and SHOW_LOGIN_LINK) or
                ($link['page_type'] == 15 and SHOW_HELP_LINK)) {
                    $z .= '<li><a class="nav_link' . $selected . '" href="' . URL . $link['url'] . '/' . append_url(0) . '">' . $link['name'] . '</a></li>';
            }
        }
        $z .= "</ul>";


        if (user_type() > 0) {
            // member links
            $z .= '<span class="nav_links_heading">' . MEMBERS_NAME . ' Links:</span><br /><br />';
            $z .= '<ul>';
            if (!$mysql->build_array('SELECT * FROM sections WHERE type = 2 AND hidden = 0 ORDER BY position ASC')) {
                $this->error = $mysql->error;
                return false;
            }
            foreach ($mysql->result as $link) {
                $selected = '';
                if ($link['page_id']) {
                    if (isset($_GET['page_id']) and isset($_GET['page_type'])) {
                        if ($_GET['page_id'] == $link['page_id'] and $_GET['page_type'] == 1) {
                            $selected = '_selected';
                        }
                    }
                    if ((($link['page_id'] == 3 or $link['page_id'] == 4 or $link['page_id'] == 5) and ENABLE_NOTICEBOARD) or ($link['page_id'] == 7 and ENABLE_ARTICLES) or ($link['page_id'] == 8 and ENABLE_EVENTS) or ($link['page_id'] == 9 and ENABLE_FAQ) or ($link['page_id'] == 10 and ENABLE_LINKS) or ($link['page_id'] == 2) or ($link['page_id'] == 6 and ENABLE_MEMBER_EDIT_COLOURS) or ($link['page_id'] == 12 and ALLOW_MEMBER_ADMIN_CATEGORIES)) {
                        $z .= '<li><a class="nav_link' . $selected . '" href="' . URL . MEMBERS_URL . '/' . $link['url'] . '/' . append_url(0) . '">' . $link['name'] . '</a></li>';
                    }
                } else {
                    if (!isset($_GET['page_id']) and isset($_GET['page_type'])) {
                        if ($_GET['page_type'] == 1) {
                            $selected = '_selected';
                        }
                    }
                    $z .= ' <li><a class="nav_link' . $selected . '" href="' . URL.MEMBERS_URL . '/' . append_url(0) . '">' . MEMBERS_NAME . ' Home</a></li>';
                }
            }
            $z .= '</ul>';
            if (user_type() == 2) {
                $z .= '<span class="nav_links_heading">' . ucwords(ADMIN_NAME_SINGULAR) . ' Links:</span><br /><br />';
                $z .= '<ul>';
                if (!$mysql->build_array('SELECT * FROM sections WHERE type = 3 AND hidden = 0 ORDER BY position ASC')) {
                    $this->error = $mysql->error;
                    return false;
                }
                $secondary_mysql = new mysql;
                foreach ($mysql->result as $link) {
                    if ($link['page_id']) {
                        $selected = '';
                        if (isset($_GET['page_id']) and isset($_GET['page_type'])) {
                            if ($_GET['page_id'] == $link['page_id'] and $_GET['page_type'] == 1) {
                                $selected = '_selected';
                            }
                        }
                        $print = false;
                        if ((($link['page_id'] == 100 or $link['page_id'] == 101 or $link['page_id'] == 103) and ENABLE_NOTICEBOARD) or ($link['page_id'] == 109 and ENABLE_EMAIL)) {
                            $print = true;
                        } elseif($link['page_id'] == 102 or $link['page_id'] == 104 or $link['page_id'] == 106) {
                            $print = true;
                        } elseif($link['page_id'] == 105 and ENABLE_ARTICLES) {
                            $secondary_mysql->num_rows('SELECT * FROM articles WHERE validated = 0');
                            if ($secondary_mysql->num_rows) {
                                $print = true;
                            }
                        } elseif($link['page_id'] == 107) {
                            $secondary_mysql->num_rows('SELECT * FROM events WHERE validated = 0');
                            if ($secondary_mysql->num_rows and ENABLE_EVENTS) {
                                $print = true;
                            }
                        }
                        if ($print) {
                            $z .= ' <li><a class="nav_link' . $selected . '" href="' . URL . ADMIN_URL . '/' . $link['url'] . '/' . append_url(0) . '">' . $link['name'] . '</a></li>';
                        }
                    }
                }
            }
        }
        $z .= '</ul>';
        $z .= '</div>';
        $z .= '<!-- /nav_links -->';
        $this->xhtml = $z;
        return true;
    }


}

?>